/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudmigrations.model.UpdateMigrationPlanDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateMigrationPlanRequest
extends BmcRequest<UpdateMigrationPlanDetails> {
    private String migrationPlanId;
    private UpdateMigrationPlanDetails updateMigrationPlanDetails;
    private String opcRetryToken;
    private String ifMatch;
    private String opcRequestId;

    public String getMigrationPlanId() {
        return this.migrationPlanId;
    }

    public UpdateMigrationPlanDetails getUpdateMigrationPlanDetails() {
        return this.updateMigrationPlanDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateMigrationPlanDetails getBody$() {
        return this.updateMigrationPlanDetails;
    }

    public Builder toBuilder() {
        return new Builder().migrationPlanId(this.migrationPlanId).updateMigrationPlanDetails(this.updateMigrationPlanDetails).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",migrationPlanId=").append(String.valueOf(this.migrationPlanId));
        sb.append(",updateMigrationPlanDetails=").append(String.valueOf((Object)this.updateMigrationPlanDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMigrationPlanRequest)) {
            return false;
        }
        UpdateMigrationPlanRequest other = (UpdateMigrationPlanRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.migrationPlanId, other.migrationPlanId) && Objects.equals((Object)this.updateMigrationPlanDetails, (Object)other.updateMigrationPlanDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.migrationPlanId == null ? 43 : this.migrationPlanId.hashCode());
        result = result * 59 + (this.updateMigrationPlanDetails == null ? 43 : this.updateMigrationPlanDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateMigrationPlanRequest, UpdateMigrationPlanDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String migrationPlanId = null;
        private UpdateMigrationPlanDetails updateMigrationPlanDetails = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder migrationPlanId(String migrationPlanId) {
            this.migrationPlanId = migrationPlanId;
            return this;
        }

        public Builder updateMigrationPlanDetails(UpdateMigrationPlanDetails updateMigrationPlanDetails) {
            this.updateMigrationPlanDetails = updateMigrationPlanDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateMigrationPlanRequest o) {
            this.migrationPlanId(o.getMigrationPlanId());
            this.updateMigrationPlanDetails(o.getUpdateMigrationPlanDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateMigrationPlanRequest build() {
            UpdateMigrationPlanRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateMigrationPlanDetails body) {
            this.updateMigrationPlanDetails(body);
            return this;
        }

        public UpdateMigrationPlanRequest buildWithoutInvocationCallback() {
            UpdateMigrationPlanRequest request = new UpdateMigrationPlanRequest();
            request.migrationPlanId = this.migrationPlanId;
            request.updateMigrationPlanDetails = this.updateMigrationPlanDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

