/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.serialization.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.oracle.bmc.http.client.InternalSdk;
import com.oracle.bmc.http.client.Serializer;
import com.oracle.bmc.serialization.jackson.internal.ExplicitlySetFilter;
import com.oracle.bmc.serialization.jackson.internal.Rfc3339DateFormat;
import java.io.IOException;
import java.text.DateFormat;

@InternalSdk
public final class JacksonSerializer
implements Serializer {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    private static final JacksonSerializer DEFAULT_SERIALIZER = new JacksonSerializer(DEFAULT_OBJECT_MAPPER);
    private final ObjectMapper objectMapper;

    @InternalSdk
    JacksonSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> T readValue(String s, Class<T> type) throws IOException {
        return (T)this.objectMapper.readValue(s, type);
    }

    public <T> T readValue(byte[] bytes, Class<T> type) throws IOException {
        return (T)this.objectMapper.readValue(bytes, type);
    }

    public String writeValueAsString(Object o) throws IOException {
        return this.objectMapper.writeValueAsString(o);
    }

    @InternalSdk
    public static JacksonSerializer getDefaultSerializer() {
        return DEFAULT_SERIALIZER;
    }

    @InternalSdk
    public static ObjectMapper getDefaultObjectMapper() {
        return DEFAULT_OBJECT_MAPPER;
    }

    static {
        DEFAULT_OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DEFAULT_OBJECT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        DEFAULT_OBJECT_MAPPER.setDateFormat((DateFormat)((Object)new Rfc3339DateFormat()));
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("explicitlySetFilter", (SimpleBeanPropertyFilter)ExplicitlySetFilter.INSTANCE);
        DEFAULT_OBJECT_MAPPER.setFilterProvider((FilterProvider)filters);
    }
}

