/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey;

import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.jersey.JerseyHttpRequest;
import com.oracle.bmc.http.client.jersey.internal.IdleConnectionMonitor;
import java.util.List;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import org.apache.http.conn.HttpClientConnectionManager;

final class JerseyHttpClient
implements HttpClient {
    final List<RequestInterceptor> requestInterceptors;
    private final WebTarget baseTarget;
    final Client client;
    final boolean isApacheNonBufferingClient;
    final HttpClientConnectionManager httpClientConnectionManager;

    JerseyHttpClient(Client client, WebTarget baseTarget, List<RequestInterceptor> requestInterceptors, boolean isApacheNonBufferingClient) {
        this(client, baseTarget, requestInterceptors, isApacheNonBufferingClient, null);
    }

    JerseyHttpClient(Client client, WebTarget baseTarget, List<RequestInterceptor> requestInterceptors, boolean isApacheNonBufferingClient, HttpClientConnectionManager httpClientConnectionManager) {
        this.client = client;
        this.baseTarget = baseTarget;
        this.requestInterceptors = requestInterceptors;
        this.isApacheNonBufferingClient = isApacheNonBufferingClient;
        this.httpClientConnectionManager = httpClientConnectionManager;
    }

    public HttpRequest createRequest(Method method) {
        return new JerseyHttpRequest(this, method, this.baseTarget);
    }

    public void close() {
        if (this.httpClientConnectionManager != null) {
            IdleConnectionMonitor.removeConnectionManager(this.httpClientConnectionManager);
        }
        this.client.close();
    }

    public boolean isProcessingException(Exception e) {
        return e instanceof ProcessingException;
    }
}

