/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey3;

import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.jersey3.Jersey3HttpRequest;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import java.util.List;

final class Jersey3HttpClient
implements HttpClient {
    final List<RequestInterceptor> requestInterceptors;
    private final WebTarget baseTarget;
    final Client client;
    final boolean isApacheNonBufferingClient;

    Jersey3HttpClient(Client client, WebTarget baseTarget, List<RequestInterceptor> requestInterceptors, boolean isApacheNonBufferingClient) {
        this.client = client;
        this.baseTarget = baseTarget;
        this.requestInterceptors = requestInterceptors;
        this.isApacheNonBufferingClient = isApacheNonBufferingClient;
    }

    public HttpRequest createRequest(Method method) {
        return new Jersey3HttpRequest(this, method, this.baseTarget);
    }

    public void close() {
        this.client.close();
    }

    public boolean isProcessingException(Exception e) {
        return e instanceof ProcessingException;
    }
}

