/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.internal;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ClientThreadFactory
implements ThreadFactory {
    private final String nameFormat;
    private final Boolean isDaemon;
    private final AtomicLong count = new AtomicLong(0L);

    private ClientThreadFactory(String nameFormat, Boolean isDaemon) {
        Objects.requireNonNull(nameFormat, "nameFormat cannot be null");
        this.nameFormat = nameFormat;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        if (this.nameFormat != null) {
            thread.setName(String.format(this.nameFormat, this.count.getAndIncrement()));
        }
        if (this.isDaemon != null) {
            thread.setDaemon(this.isDaemon);
        }
        return thread;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String nameFormat;
        private Boolean isDaemon;

        public Builder isDaemon(boolean isDaemon) {
            this.isDaemon = isDaemon;
            return this;
        }

        public Builder nameFormat(String nameFormat) {
            this.nameFormat = nameFormat;
            return this;
        }

        public ClientThreadFactory build() {
            if (this.nameFormat.isEmpty()) {
                throw new NullPointerException("nameFormat must not be blank");
            }
            return new ClientThreadFactory(this.nameFormat, this.isDaemon);
        }
    }
}

