/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.oracle.bmc.util.internal.NameUtils;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public final class Realm
implements Serializable,
Comparable<Realm> {
    private static final Map<String, Realm> KNOWN_REALMS = new LinkedHashMap<String, Realm>();
    public static final Realm OC1 = new Realm("oc1", "oraclecloud.com");
    public static final Realm OC2 = new Realm("oc2", "oraclegovcloud.com");
    public static final Realm OC3 = new Realm("oc3", "oraclegovcloud.com");
    private static final long serialVersionUID = -905344971L;
    private final String realmId;
    private final String secondLevelDomain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Realm(@NonNull String realmId, @NonNull String secondLevelDomain) {
        if (realmId == null) {
            throw new NullPointerException("realmId is marked @NonNull but is null");
        }
        if (secondLevelDomain == null) {
            throw new NullPointerException("secondLevelDomain is marked @NonNull but is null");
        }
        this.realmId = realmId;
        this.secondLevelDomain = secondLevelDomain;
        Map<String, Realm> map = KNOWN_REALMS;
        synchronized (map) {
            KNOWN_REALMS.put(NameUtils.canonicalizeForEnumTypes(realmId), this);
        }
    }

    @Override
    public int compareTo(Realm other) {
        return this.realmId.compareTo(other.realmId);
    }

    public String toString() {
        return NameUtils.canonicalizeForEnumTypes(this.getRealmId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Realm[] values() {
        Map<String, Realm> map = KNOWN_REALMS;
        synchronized (map) {
            return KNOWN_REALMS.values().toArray(new Realm[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Realm valueOf(@NonNull String name) throws IllegalArgumentException {
        Realm realm;
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        Map<String, Realm> map = KNOWN_REALMS;
        synchronized (map) {
            realm = KNOWN_REALMS.get(name);
        }
        if (realm == null) {
            throw new IllegalArgumentException("Unknown realm " + name);
        }
        return realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Realm register(@NonNull String realmId, @NonNull String secondLevelDomain) {
        if (realmId == null) {
            throw new NullPointerException("realmId is marked @NonNull but is null");
        }
        if (secondLevelDomain == null) {
            throw new NullPointerException("secondLevelDomain is marked @NonNull but is null");
        }
        realmId = realmId.toLowerCase(Locale.US);
        secondLevelDomain = secondLevelDomain.toLowerCase(Locale.US);
        Map<String, Realm> map = KNOWN_REALMS;
        synchronized (map) {
            for (Realm realm : Realm.values()) {
                if (!realm.realmId.equals(realmId)) continue;
                if (!realm.secondLevelDomain.equals(secondLevelDomain)) {
                    throw new IllegalArgumentException("RealmId : " + realmId + " is already registered with " + realm.getSecondLevelDomain() + ". It cannot be re-registered with a different secondLevelDomain");
                }
                return realm;
            }
            return new Realm(realmId, secondLevelDomain);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Realm)) {
            return false;
        }
        Realm other = (Realm)o;
        String this$realmId = this.getRealmId();
        String other$realmId = other.getRealmId();
        if (this$realmId == null ? other$realmId != null : !this$realmId.equals(other$realmId)) {
            return false;
        }
        String this$secondLevelDomain = this.getSecondLevelDomain();
        String other$secondLevelDomain = other.getSecondLevelDomain();
        return !(this$secondLevelDomain == null ? other$secondLevelDomain != null : !this$secondLevelDomain.equals(other$secondLevelDomain));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $realmId = this.getRealmId();
        result = result * 59 + ($realmId == null ? 43 : $realmId.hashCode());
        String $secondLevelDomain = this.getSecondLevelDomain();
        result = result * 59 + ($secondLevelDomain == null ? 43 : $secondLevelDomain.hashCode());
        return result;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getSecondLevelDomain() {
        return this.secondLevelDomain;
    }
}

