/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.google.common.base.Optional;
import com.oracle.bmc.Realm;
import com.oracle.bmc.Service;
import com.oracle.bmc.internal.EndpointBuilder;
import com.oracle.bmc.util.internal.NameUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Region
implements Serializable,
Comparable<Region> {
    private static final Logger LOG = LoggerFactory.getLogger(Region.class);
    private static final Map<String, Region> KNOWN_REGIONS = new LinkedHashMap<String, Region>();
    public static final Region AP_MUMBAI_1 = Region.register("ap-mumbai-1", Realm.OC1);
    public static final Region AP_SEOUL_1 = Region.register("ap-seoul-1", Realm.OC1);
    public static final Region AP_TOKYO_1 = Region.register("ap-tokyo-1", Realm.OC1);
    public static final Region CA_TORONTO_1 = Region.register("ca-toronto-1", Realm.OC1);
    public static final Region EU_FRANKFURT_1 = Region.register("eu-frankfurt-1", Realm.OC1, "fra");
    public static final Region UK_LONDON_1 = Region.register("uk-london-1", Realm.OC1, "lhr");
    public static final Region US_ASHBURN_1 = Region.register("us-ashburn-1", Realm.OC1, "iad");
    public static final Region US_PHOENIX_1 = Region.register("us-phoenix-1", Realm.OC1, "phx");
    public static final Region US_LANGLEY_1 = Region.register("us-langley-1", Realm.OC2);
    public static final Region US_LUKE_1 = Region.register("us-luke-1", Realm.OC2);
    public static final Region US_GOV_ASHBURN_1 = Region.register("us-gov-ashburn-1", Realm.OC3);
    public static final Region US_GOV_CHICAGO_1 = Region.register("us-gov-chicago-1", Realm.OC3);
    public static final Region US_GOV_PHOENIX_1 = Region.register("us-gov-phoenix-1", Realm.OC3);
    private static final Map<String, Map<Region, String>> SERVICE_TO_REGION_ENDPOINTS = new HashMap<String, Map<Region, String>>();
    private static final long serialVersionUID = -905384971L;
    private final String regionId;
    @Deprecated
    private final Optional<String> regionCode;
    private final Realm realm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region(@NonNull String regionId, @NonNull Optional<String> regionCode, @NonNull Realm realm) {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked @NonNull but is null");
        }
        if (regionCode == null) {
            throw new NullPointerException("regionCode is marked @NonNull but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked @NonNull but is null");
        }
        this.regionId = regionId;
        this.regionCode = regionCode;
        this.realm = realm;
        Map<String, Region> map = KNOWN_REGIONS;
        synchronized (map) {
            KNOWN_REGIONS.put(NameUtils.canonicalizeForEnumTypes(regionId), this);
        }
    }

    @Deprecated
    public String getRegionCode() {
        return (String)this.regionCode.or((Object)this.regionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> getEndpoint(Service service) {
        Map<String, Map<Region, String>> map = SERVICE_TO_REGION_ENDPOINTS;
        synchronized (map) {
            Map<Object, Object> endpoints;
            if (!SERVICE_TO_REGION_ENDPOINTS.containsKey(service.getServiceName())) {
                endpoints = new HashMap<Region, String>();
                ((HashMap)endpoints).put(this, Region.formatDefaultRegionEndpoint(service, this));
                SERVICE_TO_REGION_ENDPOINTS.put(service.getServiceName(), endpoints);
                LOG.info("Loaded service '{}' endpoint mappings: {}", (Object)service.getServiceName(), endpoints);
            }
            if (!(endpoints = SERVICE_TO_REGION_ENDPOINTS.get(service.getServiceName())).containsKey(this)) {
                endpoints.put(this, Region.formatDefaultRegionEndpoint(service, this));
                LOG.info("Loaded service '{}' endpoint mappings: {}", (Object)service.getServiceName(), endpoints);
            }
            String endpoint = SERVICE_TO_REGION_ENDPOINTS.get(service.getServiceName()).get(this);
            return Optional.fromNullable((Object)endpoint);
        }
    }

    @Override
    public int compareTo(Region other) {
        return this.regionId.compareTo(other.regionId);
    }

    public String toString() {
        return NameUtils.canonicalizeForEnumTypes(this.getRegionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region[] values() {
        Map<String, Region> map = KNOWN_REGIONS;
        synchronized (map) {
            return KNOWN_REGIONS.values().toArray(new Region[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region valueOf(@NonNull String name) throws IllegalArgumentException {
        Region region;
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        Map<String, Region> map = KNOWN_REGIONS;
        synchronized (map) {
            region = KNOWN_REGIONS.get(name);
        }
        if (region == null) {
            throw new IllegalArgumentException("Unknown region " + name);
        }
        return region;
    }

    public static String formatDefaultRegionEndpoint(Service service, Region region) {
        return EndpointBuilder.createEndpoint(service, region);
    }

    public static String formatDefaultRegionEndpoint(Service service, String regionId) {
        Optional<Region> maybeRegion = Region.maybeFromRegionId(regionId);
        if (maybeRegion.isPresent()) {
            return Region.formatDefaultRegionEndpoint(service, (Region)maybeRegion.get());
        }
        LOG.debug("Unknown regionId '{}', will assume it's in Realm OC1", (Object)regionId);
        return EndpointBuilder.createEndpoint(service, regionId, Realm.OC1);
    }

    public static Region fromRegionId(String regionId) {
        Optional<Region> maybeRegion = Region.maybeFromRegionId(regionId);
        if (maybeRegion.isPresent()) {
            return (Region)maybeRegion.get();
        }
        throw new IllegalArgumentException("Unknown regionId: " + regionId);
    }

    private static Optional<Region> maybeFromRegionId(String regionId) {
        for (Region region : Region.values()) {
            if (!region.regionId.equals(regionId)) continue;
            return Optional.of((Object)region);
        }
        return Optional.absent();
    }

    @Deprecated
    public static Region fromRegionCode(String regionCode) {
        for (Region region : Region.values()) {
            if (region.getRegionCode().compareToIgnoreCase(regionCode) != 0) continue;
            return region;
        }
        throw new IllegalArgumentException("Unknown regionId: " + regionCode);
    }

    @Deprecated
    public static Region fromRegionCodeOrId(String regionCodeOrId) {
        for (Region region : Region.values()) {
            if (region.getRegionCode().compareToIgnoreCase(regionCodeOrId) != 0 && region.regionId.compareToIgnoreCase(regionCodeOrId) != 0) continue;
            return region;
        }
        throw new IllegalArgumentException("Unknown region: " + regionCodeOrId);
    }

    public static Region register(@NonNull String regionId, @NonNull Realm realm) {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked @NonNull but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked @NonNull but is null");
        }
        return Region.register(regionId, realm, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region register(@NonNull String regionId, @NonNull Realm realm, String regionCode) {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked @NonNull but is null");
        }
        if (realm == null) {
            throw new NullPointerException("realm is marked @NonNull but is null");
        }
        if ((regionId = regionId.trim().toLowerCase(Locale.US)).isEmpty()) {
            throw new IllegalArgumentException("Cannot have empty regionId");
        }
        Map<String, Region> map = KNOWN_REGIONS;
        synchronized (map) {
            for (Region region : Region.values()) {
                if (!region.getRegionId().equals(regionId)) continue;
                if (!region.getRealm().equals(realm)) {
                    throw new IllegalArgumentException("Region : " + regionId + " is already registered with " + region.getRealm() + ". It cannot be re-registered with a different realm.");
                }
                return region;
            }
            if (regionCode != null && (regionCode = regionCode.trim().toLowerCase(Locale.US)).isEmpty()) {
                regionCode = null;
            }
            return new Region(regionId, (Optional<String>)Optional.fromNullable((Object)regionCode), realm);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Region)) {
            return false;
        }
        Region other = (Region)o;
        String this$regionId = this.getRegionId();
        String other$regionId = other.getRegionId();
        if (this$regionId == null ? other$regionId != null : !this$regionId.equals(other$regionId)) {
            return false;
        }
        String this$regionCode = this.getRegionCode();
        String other$regionCode = other.getRegionCode();
        if (this$regionCode == null ? other$regionCode != null : !this$regionCode.equals(other$regionCode)) {
            return false;
        }
        Realm this$realm = this.getRealm();
        Realm other$realm = other.getRealm();
        return !(this$realm == null ? other$realm != null : !((Object)this$realm).equals(other$realm));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $regionId = this.getRegionId();
        result = result * 59 + ($regionId == null ? 43 : $regionId.hashCode());
        String $regionCode = this.getRegionCode();
        result = result * 59 + ($regionCode == null ? 43 : $regionCode.hashCode());
        Realm $realm = this.getRealm();
        result = result * 59 + ($realm == null ? 43 : ((Object)$realm).hashCode());
        return result;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public Realm getRealm() {
        return this.realm;
    }
}

