/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.google.common.base.Preconditions;
import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.Realm;
import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimplePrivateKeySupplier;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileAuthenticationDetailsProvider
implements AuthenticationDetailsProvider,
RegionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFileAuthenticationDetailsProvider.class);
    private final SimpleAuthenticationDetailsProvider delegate;

    public ConfigFileAuthenticationDetailsProvider(String profile) throws IOException {
        this(ConfigFileReader.parseDefault(profile));
    }

    public ConfigFileAuthenticationDetailsProvider(String configurationFilePath, String profile) throws IOException {
        this(ConfigFileReader.parse(configurationFilePath, profile));
    }

    public ConfigFileAuthenticationDetailsProvider(ConfigFileReader.ConfigFile configFile) {
        String fingerprint = (String)Preconditions.checkNotNull((Object)configFile.get("fingerprint"), (Object)"missing fingerprint in config");
        String tenantId = (String)Preconditions.checkNotNull((Object)configFile.get("tenancy"), (Object)"missing tenancy in config");
        String userId = (String)Preconditions.checkNotNull((Object)configFile.get("user"), (Object)"missing user in config");
        String pemFilePath = (String)Preconditions.checkNotNull((Object)configFile.get("key_file"), (Object)"missing key_file in config");
        String passPhrase = configFile.get("pass_phrase");
        SimplePrivateKeySupplier privateKeySupplier = new SimplePrivateKeySupplier(pemFilePath);
        Region region = null;
        String regionId = configFile.get("region");
        if (regionId != null) {
            try {
                region = Region.fromRegionId(regionId);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Found regionId '{}' in config file, but not supported by this version of the SDK", (Object)regionId, (Object)e);
                region = Region.register(regionId, Realm.OC1);
            }
        } else {
            LOG.info("Region not specified in Config file. Proceeding without setting a region.");
        }
        SimpleAuthenticationDetailsProvider.SimpleAuthenticationDetailsProviderBuilder builder = SimpleAuthenticationDetailsProvider.builder().fingerprint(fingerprint).privateKeySupplier(privateKeySupplier).tenantId(tenantId).userId(userId).region(region);
        if (passPhrase != null) {
            builder = builder.passphraseCharacters(passPhrase.toCharArray());
        }
        this.delegate = builder.build();
    }

    @Override
    public String getFingerprint() {
        return this.delegate.getFingerprint();
    }

    @Override
    public String getTenantId() {
        return this.delegate.getTenantId();
    }

    @Override
    public String getUserId() {
        return this.delegate.getUserId();
    }

    @Override
    @Deprecated
    public String getPassPhrase() {
        return this.delegate.getPassPhrase();
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.delegate.getPassphraseCharacters();
    }

    @Override
    public InputStream getPrivateKey() {
        return this.delegate.getPrivateKey();
    }

    @Override
    public String getKeyId() {
        return this.delegate.getKeyId();
    }

    @Override
    public Region getRegion() {
        return this.delegate.getRegion();
    }

    public String toString() {
        return "ConfigFileAuthenticationDetailsProvider(delegate=" + this.delegate + ")";
    }
}

