/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.auth.X509CertificateSupplier;
import com.oracle.bmc.auth.internal.X509CertificateWithOriginalPem;
import com.oracle.bmc.http.signing.internal.PEMFileRSAPrivateKeySupplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Refreshable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLBasedX509CertificateSupplier
implements X509CertificateSupplier,
Refreshable {
    private static final Logger LOG = LoggerFactory.getLogger(URLBasedX509CertificateSupplier.class);
    private static final boolean EXPERIMENTAL_SUPPRESS_X509_WORKAROUND = Boolean.getBoolean("oci.sdk.experimental.suppressX509Workaround");
    private final AtomicReference<X509CertificateSupplier.CertificateAndPrivateKeyPair> certificateAndKeyPair = new AtomicReference<Object>(null);
    private final URL certificateUrl;
    private final URL privateKeyUrl;
    private final char[] privateKeyPassphraseCharacters;

    public URLBasedX509CertificateSupplier(URL certificateUrl, URL privateKeyUrl, char[] privateKeyPassphraseCharacters) {
        this.certificateUrl = certificateUrl;
        this.privateKeyUrl = privateKeyUrl;
        this.privateKeyPassphraseCharacters = privateKeyPassphraseCharacters;
        this.refresh();
    }

    @Deprecated
    public URLBasedX509CertificateSupplier(URL certificateUrl, URL privateKeyUrl, String privateKeyPassphrase) {
        this.certificateUrl = certificateUrl;
        this.privateKeyUrl = privateKeyUrl;
        this.privateKeyPassphraseCharacters = privateKeyPassphrase != null ? privateKeyPassphrase.toCharArray() : null;
        this.refresh();
    }

    @Override
    @Deprecated
    public X509Certificate getCertificate() {
        return this.certificateAndKeyPair.get().getCertificate();
    }

    @Override
    public void refresh() {
        String rawCertificate = URLBasedX509CertificateSupplier.readRawCertificate(this.certificateUrl);
        X509Certificate certificate = URLBasedX509CertificateSupplier.readCertificate(rawCertificate);
        RSAPrivateKey privateKey = URLBasedX509CertificateSupplier.readPrivateKey(this.privateKeyUrl, this.privateKeyPassphraseCharacters);
        if (EXPERIMENTAL_SUPPRESS_X509_WORKAROUND) {
            this.certificateAndKeyPair.set(new X509CertificateSupplier.CertificateAndPrivateKeyPair(certificate, privateKey));
        } else {
            X509CertificateWithOriginalPem wrappedCertificate = new X509CertificateWithOriginalPem(certificate, rawCertificate);
            this.certificateAndKeyPair.set(new X509CertificateSupplier.CertificateAndPrivateKeyPair(wrappedCertificate, privateKey));
        }
    }

    @Override
    public boolean isCurrent() {
        return false;
    }

    private static X509Certificate readCertificate(String certificate) {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certificate.getBytes()));
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Invalid certificate.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readRawCertificate(URL certificateUrl) {
        try (InputStream is = certificateUrl.openStream();){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Open stream of certificate failed.", e);
        }
    }

    private static RSAPrivateKey readPrivateKey(URL privateKeyUrl, char[] privateKeyPassphrase) {
        if (privateKeyUrl == null) {
            return null;
        }
        try {
            return (RSAPrivateKey)new PEMFileRSAPrivateKeySupplier(privateKeyUrl.openStream(), privateKeyPassphrase).getKey(null).orNull();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("No file for private key", e);
        }
    }

    @Override
    @Deprecated
    public RSAPrivateKey getPrivateKey() {
        return this.getCertificateAndKeyPair().getPrivateKey();
    }

    @Override
    public X509CertificateSupplier.CertificateAndPrivateKeyPair getCertificateAndKeyPair() {
        return this.certificateAndKeyPair.get();
    }

    static {
        LOG.info("suppressX509Workaround flag set to {}", (Object)EXPERIMENTAL_SUPPRESS_X509_WORKAROUND);
    }
}

