/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLengthFilter
implements ClientRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ContentLengthFilter.class);

    public void filter(ClientRequestContext requestContext) {
        String contentLengthHeader = null;
        for (String key : requestContext.getHeaders().keySet()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)"content-length", (CharSequence)key)) continue;
            contentLengthHeader = key;
        }
        String method = requestContext.getMethod();
        String uri = requestContext.getUri().toString();
        Object existingContentLengthValue = requestContext.getHeaders().remove((Object)contentLengthHeader);
        if (existingContentLengthValue != null) {
            LOG.debug("Removed existing content-length header for Method [{}], URI [{}], Existing Value [{}]", new Object[]{method, uri, existingContentLengthValue});
        } else {
            LOG.debug("content-length not found for Method [{}], URI [{}]", (Object)method, (Object)uri);
        }
    }
}

