/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.google.common.base.Joiner;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import lombok.NonNull;

@Priority(value=999)
public class CrossTenancyRequestClientFilter
implements ClientRequestFilter {
    public static final int PRIORITY = 999;
    private final String authorizedTenancyIdsValue;

    public CrossTenancyRequestClientFilter(String[] authorizedTenancyIds) {
        if (authorizedTenancyIds == null || authorizedTenancyIds.length == 0) {
            throw new IllegalArgumentException("Must provide at least one authorized tenancyId");
        }
        for (String authorizedTenancyId : authorizedTenancyIds) {
            if (authorizedTenancyId != null && !authorizedTenancyId.isEmpty()) continue;
            throw new IllegalArgumentException("Authorized tenancyId was not valid");
        }
        this.authorizedTenancyIdsValue = Joiner.on((String)",").join((Object[])authorizedTenancyIds);
    }

    public void filter(@NonNull ClientRequestContext clientRequestContext) throws IOException {
        if (clientRequestContext == null) {
            throw new NullPointerException("clientRequestContext is marked @NonNull but is null");
        }
        clientRequestContext.getHeaders().putSingle((Object)"x-cross-tenancy-request", (Object)this.authorizedTenancyIdsValue);
    }
}

