/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.google.common.base.Function;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.WithHeaders;
import java.beans.ConstructorProperties;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

public class ResponseConversionFunctionFactory {
    public Function<Response, WithHeaders<Void>> create() {
        return new ParseResponseOnlyHeadersFunction();
    }

    public <T> Function<Response, WithHeaders<T>> create(Class<T> clazz) {
        return new ParseResponseWithHeadersFunction<T>(clazz);
    }

    public <T> Function<Response, WithHeaders<T>> create(GenericType<T> type) {
        return new ParseGenericResponseWithHeadersFunction<T>(type);
    }

    private static abstract class ValidatingParseResponseFunction<T>
    implements Function<Response, T> {
        private ValidatingParseResponseFunction() {
        }

        public final T apply(Response response) {
            ResponseHelper.throwIfNotSuccessful(response);
            return this.doApply(response);
        }

        protected abstract T doApply(Response var1);
    }

    private static final class ParseResponseOnlyHeadersFunction
    extends ValidatingParseResponseFunction<WithHeaders<Void>> {
        private ParseResponseOnlyHeadersFunction() {
        }

        @Override
        protected WithHeaders<Void> doApply(Response response) {
            return new WithHeaders<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response.getStatus());
        }
    }

    private static final class ParseGenericResponseWithHeadersFunction<T>
    extends ValidatingParseResponseFunction<WithHeaders<T>> {
        private final GenericType<T> genericType;

        @Override
        protected WithHeaders<T> doApply(Response response) {
            T entity = ResponseHelper.readEntity(response, this.genericType);
            return new WithHeaders<T>(entity, (MultivaluedMap<String, String>)response.getStringHeaders(), response.getStatus());
        }

        @ConstructorProperties(value={"genericType"})
        public ParseGenericResponseWithHeadersFunction(GenericType<T> genericType) {
            this.genericType = genericType;
        }
    }

    private static final class ParseResponseWithHeadersFunction<T>
    extends ValidatingParseResponseFunction<WithHeaders<T>> {
        private final Class<T> responseClass;

        @Override
        protected WithHeaders<T> doApply(Response response) {
            T entity = ResponseHelper.readEntity(response, this.responseClass);
            return new WithHeaders<T>(entity, (MultivaluedMap<String, String>)response.getStringHeaders(), response.getStatus());
        }

        @ConstructorProperties(value={"responseClass"})
        public ParseResponseWithHeadersFunction(Class<T> responseClass) {
            this.responseClass = responseClass;
        }
    }
}

