/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.io.internal;

import com.oracle.bmc.io.DuplicatableInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class WrappedFileInputStream
extends FileInputStream
implements DuplicatableInputStream {
    private final File sourceFile;
    private long markPosition = 0L;

    public WrappedFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.sourceFile = file;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.markPosition = super.getChannel().position();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not mark position");
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        super.getChannel().position(this.markPosition);
    }

    @Override
    public InputStream duplicate() {
        return WrappedFileInputStream.create(this.sourceFile);
    }

    public static WrappedFileInputStream create(File file) {
        try {
            return new WrappedFileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File not found", e);
        }
    }

    public File getSourceFile() {
        return this.sourceFile;
    }
}

