/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Retriers {
    private static final Logger LOG = LoggerFactory.getLogger(Retriers.class);
    private static volatile RetryConfiguration DEFAULT_RETRY_CONFIGURATION = RetryConfiguration.NO_RETRY_CONFIGURATION;
    private static volatile boolean SEND_OPC_RETRY_TOKEN = true;

    public static void setDefaultRetryConfiguration(@NonNull RetryConfiguration retryConfiguration) {
        if (retryConfiguration == null) {
            throw new NullPointerException("retryConfiguration is marked @NonNull but is null");
        }
        LOG.info("Setting default retry configuration to {}", (Object)retryConfiguration);
        DEFAULT_RETRY_CONFIGURATION = retryConfiguration;
    }

    public static void shouldSendOpcRetryToken(boolean shouldSendOpcRetryToken) {
        LOG.info("Setting shouldSendOpcRetryToken to {}", (Object)shouldSendOpcRetryToken);
        SEND_OPC_RETRY_TOKEN = shouldSendOpcRetryToken;
    }

    public static boolean shouldSendOpcRetryToken() {
        return SEND_OPC_RETRY_TOKEN;
    }

    public static BmcGenericRetrier createPreferredRetrier(@Nullable RetryConfiguration requestRetryConfiguration, @Nullable RetryConfiguration clientRetryConfiguration) {
        RetryConfiguration preferredRetryConfiguration = Stream.of(requestRetryConfiguration, clientRetryConfiguration, DEFAULT_RETRY_CONFIGURATION).filter(Objects::nonNull).findFirst().get();
        LOG.debug("Using retry configuration: {}", (Object)preferredRetryConfiguration);
        return new BmcGenericRetrier(preferredRetryConfiguration);
    }

    private Retriers() {
    }
}

