/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.oracle.bmc.util.internal.Validate;
import java.text.ParseException;
import java.util.Date;

public class JwtClaimsSet {
    private final JWTClaimsSet jwt;

    public JwtClaimsSet(String token) {
        Validate.notBlank(token, "token must not be null or empty", new Object[0]);
        this.jwt = JwtClaimsSet.parse(token);
    }

    static JWTClaimsSet parse(String token) {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            if (signedJWT.getSignature().toString().isEmpty()) {
                throw new IllegalArgumentException("The token doesn't have a signature");
            }
            return signedJWT.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The token does not conform to signed JWT format. " + e.getMessage());
        }
    }

    public Date getExpirationTime() {
        return this.jwt.getExpirationTime();
    }

    public String getStringClaim(String jwk) throws ParseException {
        return this.jwt.getStringClaim(jwk);
    }

    public Object getClaim(String jwk) {
        return this.jwt.getClaim(jwk);
    }
}

