/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ApacheConfigurator;
import com.oracle.bmc.http.ClientConfigDecorator;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.HasEffectiveClientConfigurator;
import com.oracle.bmc.http.JerseyDefaultConnectorConfigurator;
import com.oracle.bmc.http.SetsClientBuilderProperties;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.ReflectionUtils;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurator
implements ClientConfigurator,
HasEffectiveClientConfigurator,
SetsClientBuilderProperties {
    protected static final String APACHE_HTTP_CLIENT_CONFIG_CLASS_NAME = "org.apache.http.client.config.RequestConfig";
    protected static final String APACHE_CONNECTOR_CLASS_NAME = "org.glassfish.jersey.apache.connector.ApacheConnector";
    private static final String OCI_JAVASDK_JERSEY_CLIENT_DEFAULT_CONNECTOR_ENABLED_ENV_VAR = "OCI_JAVASDK_JERSEY_CLIENT_DEFAULT_CONNECTOR_ENABLED";
    private static final boolean isApacheDependencyPresent = DefaultConfigurator.checkForApacheDependencies() && !DefaultConfigurator.jerseyDefaultConnectorEnabled();
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurator.class);
    protected final List<ClientConfigDecorator> clientConfigDecorators = new LinkedList<ClientConfigDecorator>();
    private final ClientConfigurator effectiveClientConfigurator;

    private static boolean checkForApacheDependencies() {
        return ReflectionUtils.isClassPresent(APACHE_HTTP_CLIENT_CONFIG_CLASS_NAME, DefaultConfigurator.class) && ReflectionUtils.isClassPresent(APACHE_CONNECTOR_CLASS_NAME, DefaultConfigurator.class);
    }

    private static boolean jerseyDefaultConnectorEnabled() {
        String trimmedValue;
        String jerseyDefaultConnectorEnabledString = System.getenv(OCI_JAVASDK_JERSEY_CLIENT_DEFAULT_CONNECTOR_ENABLED_ENV_VAR);
        return jerseyDefaultConnectorEnabledString != null && !jerseyDefaultConnectorEnabledString.isEmpty() && "true".equalsIgnoreCase(trimmedValue = jerseyDefaultConnectorEnabledString.trim());
    }

    public DefaultConfigurator() {
        this.effectiveClientConfigurator = DefaultConfigurator.isApacheDependencyPresent() ? new ApacheConfigurator() : new JerseyDefaultConnectorConfigurator();
    }

    public DefaultConfigurator(List<ClientConfigDecorator> clientConfigDecorators) {
        this.clientConfigDecorators.addAll(clientConfigDecorators);
        this.effectiveClientConfigurator = DefaultConfigurator.isApacheDependencyPresent() ? new ApacheConfigurator(this.clientConfigDecorators) : new JerseyDefaultConnectorConfigurator(this.clientConfigDecorators);
    }

    public static boolean isApacheDependencyPresent() {
        return isApacheDependencyPresent;
    }

    @Override
    public void customizeBuilder(ClientBuilder builder) {
        this.effectiveClientConfigurator.customizeBuilder(builder);
    }

    @Override
    public void customizeClient(Client client) {
        this.effectiveClientConfigurator.customizeClient(client);
    }

    @Override
    public void setConnectorProvider(ClientBuilder builder) {
        try {
            SetsClientBuilderProperties setsClientBuilderProperties = (SetsClientBuilderProperties)((Object)this.effectiveClientConfigurator);
            setsClientBuilderProperties.setConnectorProvider(builder);
        }
        catch (Exception e) {
            LOG.info("Cannot call setConnectorProvider on this ClientConfigurator");
        }
    }

    @Override
    public void setSslContext(ClientBuilder builder) {
        try {
            SetsClientBuilderProperties setsClientBuilderProperties = (SetsClientBuilderProperties)((Object)this.effectiveClientConfigurator);
            setsClientBuilderProperties.setSslContext(builder);
        }
        catch (Exception e) {
            LOG.info("Cannot call setSslContext on this ClientConfigurator");
        }
    }

    @Override
    public void customizeRequest(BmcRequest<?> request, WrappedInvocationBuilder ib) {
        this.effectiveClientConfigurator.customizeRequest(request, ib);
    }

    @Override
    public ClientConfigurator getEffectiveClientConfigurator() {
        return this.effectiveClientConfigurator;
    }

    public static class NonBuffering
    extends DefaultConfigurator
    implements ClientConfigurator,
    HasEffectiveClientConfigurator,
    SetsClientBuilderProperties {
        private final ClientConfigurator effectiveClientConfigurator = NonBuffering.isApacheDependencyPresent() ? new ApacheConfigurator.NonBuffering() : new JerseyDefaultConnectorConfigurator.NonBuffering();

        @Override
        public void customizeBuilder(ClientBuilder builder) {
            this.effectiveClientConfigurator.customizeBuilder(builder);
        }

        @Override
        public void customizeClient(Client client) {
            this.effectiveClientConfigurator.customizeClient(client);
        }

        @Override
        public void customizeRequest(BmcRequest<?> request, WrappedInvocationBuilder ib) {
            this.effectiveClientConfigurator.customizeRequest(request, ib);
        }

        @Override
        public void setConnectorProvider(ClientBuilder builder) {
            try {
                SetsClientBuilderProperties setsClientBuilderProperties = (SetsClientBuilderProperties)((Object)this.effectiveClientConfigurator);
                setsClientBuilderProperties.setConnectorProvider(builder);
            }
            catch (ClassCastException e) {
                LOG.info("Cannot call setConnectorProvider on this ClientConfigurator");
            }
        }

        @Override
        public void setSslContext(ClientBuilder builder) {
            try {
                SetsClientBuilderProperties setsClientBuilderProperties = (SetsClientBuilderProperties)((Object)this.effectiveClientConfigurator);
                setsClientBuilderProperties.setConnectorProvider(builder);
            }
            catch (ClassCastException e) {
                LOG.info("Cannot call setSslContext on this ClientConfigurator");
            }
        }

        @Override
        public ClientConfigurator getEffectiveClientConfigurator() {
            return this.effectiveClientConfigurator;
        }
    }
}

