/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ClientConfigDecorator;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.SetsClientBuilderProperties;
import com.oracle.bmc.util.JavaRuntimeUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyDefaultConnectorConfigurator
implements ClientConfigurator,
SetsClientBuilderProperties {
    static final String SUN_NET_HTTP_ALLOW_RESTRICTED_HEADERS = "sun.net.http.allowRestrictedHeaders";
    private static final Logger LOG = LoggerFactory.getLogger(JerseyDefaultConnectorConfigurator.class);
    protected final List<ClientConfigDecorator> clientConfigDecorators = new LinkedList<ClientConfigDecorator>();

    public JerseyDefaultConnectorConfigurator() {
    }

    public JerseyDefaultConnectorConfigurator(List<ClientConfigDecorator> clientConfigDecorators) {
        this.clientConfigDecorators.addAll(clientConfigDecorators);
    }

    static void setAllowRestrictedHeadersProperty(String previousValue) {
        if (previousValue != null && !Boolean.valueOf(previousValue).booleanValue()) {
            throw new IllegalStateException("Property sun.net.http.allowRestrictedHeaders was explicitly set to " + previousValue + "; the OCI SDK needs to set this property to true. Failing...");
        }
        System.setProperty(SUN_NET_HTTP_ALLOW_RESTRICTED_HEADERS, "true");
    }

    @Override
    public void customizeBuilder(ClientBuilder builder) {
        this.setSslContext(builder);
        this.setConnectorProvider(builder);
    }

    @Override
    public void setSslContext(ClientBuilder builder) {
        JavaRuntimeUtils.JreVersion version = JavaRuntimeUtils.getRuntimeVersion();
        if (version == JavaRuntimeUtils.JreVersion.Java_7) {
            LOG.info("Running on 1.7 VM, manually setting security protocol to TLSv1.2");
            SSLContext sslContext = SslConfigurator.newInstance((boolean)true).securityProtocol("TLSv1.2").createSSLContext();
            builder.sslContext(sslContext);
        } else if (version == JavaRuntimeUtils.JreVersion.Unsupported) {
            LOG.error("Using an unsupported runtime only 1.7+ is supported");
        } else if (version == JavaRuntimeUtils.JreVersion.Unknown) {
            LOG.warn("Using an unknown runtime, calls may not work");
        }
    }

    @Override
    public void setConnectorProvider(ClientBuilder builder) {
        LOG.info("Setting connector provider to HttpUrlConnectorProvider");
        ClientConfig clientConfig = new ClientConfig();
        HttpUrlConnectorProvider provider = new HttpUrlConnectorProvider().useSetMethodWorkaround();
        clientConfig.connectorProvider((ConnectorProvider)provider);
        for (ClientConfigDecorator clientConfigDecorator : this.clientConfigDecorators) {
            clientConfigDecorator.customizeClientConfig(clientConfig);
        }
        builder.withConfig((Configuration)clientConfig);
    }

    @Override
    public void customizeClient(Client client) {
        client.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
    }

    static {
        JerseyDefaultConnectorConfigurator.setAllowRestrictedHeadersProperty(System.getProperty(SUN_NET_HTTP_ALLOW_RESTRICTED_HEADERS));
    }

    private static class NonBufferingClientConfigDecorator
    implements ClientConfigDecorator {
        private NonBufferingClientConfigDecorator() {
        }

        @Override
        public void customizeClientConfig(ClientConfig clientConfig) {
            Validate.notNull(clientConfig, "ClientConfig must not be null", new Object[0]);
            ConnectorProvider provider = clientConfig.getConnectorProvider();
            if (!(provider instanceof HttpUrlConnectorProvider)) {
                return;
            }
            HttpUrlConnectorProvider httpProvider = (HttpUrlConnectorProvider)provider;
            LOG.info("Configuring non-buffering for HttpUrlConnectorProvider");
            httpProvider.useFixedLengthStreaming();
        }
    }

    public static class NonBuffering
    extends JerseyDefaultConnectorConfigurator {
        public NonBuffering() {
            this.clientConfigDecorators.add(new NonBufferingClientConfigDecorator());
        }

        @Override
        public void customizeClient(Client client) {
            super.customizeClient(client);
            client.property("jersey.config.client.request.entity.processing", null);
        }

        @Override
        public void setConnectorProvider(ClientBuilder builder) {
            super.setConnectorProvider(builder);
        }
    }
}

