/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;

@Priority(value=999)
public class CrossTenancyRequestClientFilter
implements ClientRequestFilter {
    public static final int PRIORITY = 999;
    private final String authorizedTenancyIdsValue;

    public CrossTenancyRequestClientFilter(String[] authorizedTenancyIds) {
        if (authorizedTenancyIds == null || authorizedTenancyIds.length == 0) {
            throw new IllegalArgumentException("Must provide at least one authorized tenancyId");
        }
        for (String authorizedTenancyId : authorizedTenancyIds) {
            if (authorizedTenancyId != null && !authorizedTenancyId.isEmpty()) continue;
            throw new IllegalArgumentException("Authorized tenancyId was not valid");
        }
        this.authorizedTenancyIdsValue = Arrays.asList(authorizedTenancyIds).stream().collect(Collectors.joining(","));
    }

    public void filter(@Nonnull ClientRequestContext clientRequestContext) throws IOException {
        if (clientRequestContext == null) {
            throw new NullPointerException("clientRequestContext is marked non-null but is null");
        }
        clientRequestContext.getHeaders().putSingle((Object)"x-cross-tenancy-request", (Object)this.authorizedTenancyIdsValue);
    }
}

