/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.JaxRsCircuitBreaker;
import com.oracle.bmc.circuitbreaker.NoCircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.internal.JaxRsCircuitBreakerImpl;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.AuthnClientFilter;
import com.oracle.bmc.http.internal.ClientIdFilter;
import com.oracle.bmc.http.internal.EntityFactory;
import com.oracle.bmc.http.internal.ExplicitlySetFilter;
import com.oracle.bmc.http.internal.LogHeadersFilter;
import com.oracle.bmc.http.internal.RFC3339DateFormat;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.util.VisibleForTesting;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;

public class RestClientFactory {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private static final JacksonJsonProvider JACKSON_JSON_PROVIDER = new JacksonJaxbJsonProvider(DEFAULT_MAPPER, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
    private static final ClientIdFilter CLIENT_ID_FILTER = new ClientIdFilter();
    private static final LogHeadersFilter LOG_HEADERS_FILTER = new LogHeadersFilter();
    private final ClientConfigurator clientConfigurator;

    public RestClientFactory(@Nonnull ClientConfigurator clientConfigurator) {
        this.clientConfigurator = clientConfigurator;
    }

    @Deprecated
    public RestClient create(RequestSigner requestSigner) {
        return this.create(requestSigner, Collections.emptyMap());
    }

    @Deprecated
    public RestClient create(RequestSigner requestSigner, ClientConfiguration configuration) {
        return this.create(requestSigner, Collections.emptyMap(), configuration);
    }

    public RestClient create(RequestSigner defaultRequestSigner, Map<SigningStrategy, RequestSigner> requestSigners) {
        return this.create(defaultRequestSigner, requestSigners, null);
    }

    public RestClient create(RequestSigner defaultRequestSigner, Map<SigningStrategy, RequestSigner> requestSigners, ClientConfiguration configuration) {
        return this.create(defaultRequestSigner, requestSigners, configuration, false);
    }

    public RestClient create(RequestSigner defaultRequestSigner, Map<SigningStrategy, RequestSigner> requestSigners, ClientConfiguration configuration, boolean isNonBuffering) {
        return this.create(defaultRequestSigner, requestSigners, configuration, isNonBuffering, null);
    }

    public RestClient create(RequestSigner defaultRequestSigner, Map<SigningStrategy, RequestSigner> requestSigners, ClientConfiguration configuration, boolean isNonBuffering, JaxRsCircuitBreaker circuitBreaker) {
        if (circuitBreaker == null) {
            return this.create(defaultRequestSigner, requestSigners, configuration, isNonBuffering, null, null);
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        Client client = RestClientFactory.createClient(defaultRequestSigner, requestSigners, clientConfigurationToUse, this.clientConfigurator);
        return new RestClient(client, new EntityFactory(), circuitBreaker, isNonBuffering, this.clientConfigurator);
    }

    public RestClient create(RequestSigner defaultRequestSigner, Map<SigningStrategy, RequestSigner> requestSigners, ClientConfiguration configuration, boolean isNonBuffering, JaxRsCircuitBreaker circuitBreaker, CircuitBreakerConfiguration circuitBreakerConfiguration) {
        if (circuitBreaker != null && circuitBreakerConfiguration != null) {
            throw new IllegalArgumentException("Invalid CircuitBreaker setting. Please provide either CircuitBreaker configuration or CircuitBreaker and not both");
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        Client client = RestClientFactory.createClient(defaultRequestSigner, requestSigners, clientConfigurationToUse, this.clientConfigurator);
        if (configuration != null && configuration.getCircuitBreakerConfiguration() != null && configuration.getCircuitBreaker() != null) {
            throw new IllegalArgumentException("Invalid CircuitBreaker setting. Please provide either CircuitBreaker configuration or CircuitBreaker and not both");
        }
        if (configuration != null && configuration.getCircuitBreaker() != null) {
            circuitBreaker = configuration.getCircuitBreaker();
        } else if (configuration != null && configuration.getCircuitBreakerConfiguration() != null) {
            circuitBreaker = configuration.getCircuitBreakerConfiguration() instanceof NoCircuitBreakerConfiguration ? null : new JaxRsCircuitBreakerImpl(configuration.getCircuitBreakerConfiguration());
        } else if (circuitBreakerConfiguration != null) {
            circuitBreaker = circuitBreakerConfiguration instanceof NoCircuitBreakerConfiguration ? null : new JaxRsCircuitBreakerImpl(circuitBreakerConfiguration);
        }
        return new RestClient(client, new EntityFactory(), (JaxRsCircuitBreaker)circuitBreaker, isNonBuffering, this.clientConfigurator);
    }

    @VisibleForTesting
    static Client createClient(RequestSigner defaultRequestSigner, Map<SigningStrategy, RequestSigner> requestSigners, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        ClientBuilder builder = JerseyClientBuilder.newBuilder();
        clientConfigurator.customizeBuilder(builder);
        Client client = (Client)((Client)((Client)((Client)((Client)builder.build().register((Object)JACKSON_JSON_PROVIDER)).property("jersey.config.client.connectTimeout", (Object)configuration.getConnectionTimeoutMillis())).property("jersey.config.client.readTimeout", (Object)configuration.getReadTimeoutMillis())).property("jersey.config.client.async.threadPoolSize", (Object)configuration.getMaxAsyncThreads())).property("jersey.config.jsonFeature", (Object)"JacksonFeature");
        client.register((Object)new AuthnClientFilter(defaultRequestSigner, requestSigners));
        client.register((Object)CLIENT_ID_FILTER);
        client.register((Object)LOG_HEADERS_FILTER);
        clientConfigurator.customizeClient(client);
        return client;
    }

    public static ObjectMapper getObjectMapper() {
        return DEFAULT_MAPPER;
    }

    public ClientConfigurator getClientConfigurator() {
        return this.clientConfigurator;
    }

    static {
        DEFAULT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DEFAULT_MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        DEFAULT_MAPPER.setDateFormat((DateFormat)((Object)new RFC3339DateFormat()));
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("explicitlySetFilter", (SimpleBeanPropertyFilter)ExplicitlySetFilter.INSTANCE);
        DEFAULT_MAPPER.setFilterProvider((FilterProvider)filters);
    }
}

