/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.model;

import com.oracle.bmc.ClientRuntime;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.http.internal.RFC3339DateFormat;
import com.oracle.bmc.util.internal.StringUtils;
import java.util.Date;
import java.util.Map;

public class BmcException
extends RuntimeException {
    public static final String OPC_REQUEST_ID_HEADER = "opc-request-id";
    private final int statusCode;
    private final String serviceCode;
    private final boolean timeout;
    private final String opcRequestId;
    private final boolean isClientSide;
    private ServiceDetails serviceDetails;
    private final String originalMessage;
    private final String originalMessageTemplate;
    private final Map<String, String> messageArguments;

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.serviceCode = serviceCode;
        this.opcRequestId = opcRequestId;
        this.timeout = false;
        this.isClientSide = false;
        this.originalMessage = null;
        this.originalMessageTemplate = null;
        this.messageArguments = null;
    }

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId, Throwable cause, ServiceDetails serviceDetails) {
        super(message, cause);
        this.statusCode = statusCode;
        this.serviceCode = serviceCode;
        this.opcRequestId = opcRequestId;
        this.timeout = false;
        this.isClientSide = false;
        this.serviceDetails = serviceDetails;
        this.originalMessage = null;
        this.originalMessageTemplate = null;
        this.messageArguments = null;
    }

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId) {
        super(message);
        this.statusCode = statusCode;
        this.serviceCode = serviceCode;
        this.opcRequestId = opcRequestId;
        this.timeout = false;
        this.isClientSide = false;
        this.originalMessage = null;
        this.originalMessageTemplate = null;
        this.messageArguments = null;
    }

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId, ServiceDetails serviceDetails) {
        super(message);
        this.statusCode = statusCode;
        this.serviceCode = serviceCode;
        this.opcRequestId = opcRequestId;
        this.timeout = false;
        this.isClientSide = false;
        this.serviceDetails = serviceDetails;
        this.originalMessage = null;
        this.originalMessageTemplate = null;
        this.messageArguments = null;
    }

    public BmcException(boolean timeout, String message, Throwable cause, String opcRequestId) {
        super(message, cause);
        this.statusCode = -1;
        this.serviceCode = null;
        this.opcRequestId = opcRequestId;
        this.timeout = timeout;
        this.isClientSide = true;
        this.originalMessage = null;
        this.originalMessageTemplate = null;
        this.messageArguments = null;
    }

    public BmcException(int statusCode, String serviceCode, String message, String opcRequestId, ServiceDetails serviceDetails, String originalMessage, String originalMessageTemplate, Map<String, String> templateArguments) {
        super(message);
        this.statusCode = statusCode;
        this.serviceCode = serviceCode;
        this.opcRequestId = opcRequestId;
        this.timeout = false;
        this.isClientSide = false;
        this.serviceDetails = serviceDetails;
        this.originalMessage = originalMessage;
        this.originalMessageTemplate = originalMessageTemplate;
        this.messageArguments = templateArguments;
    }

    @Override
    public String getMessage() {
        String requestId;
        String string = this.opcRequestId != null ? " (" + (this.isClientSide ? "outbound " : "") + "opc-request-id: " + this.opcRequestId + ")" : (requestId = "");
        if (null != this.serviceDetails) {
            String targetService = this.serviceDetails.getServiceName();
            String timestamp = RFC3339DateFormat.formatRfc3339(new Date(), true);
            String clientVersion = ClientRuntime.getRuntime().getClientInfo();
            String errorTroubleshootingLink = String.format("https://docs.oracle.com/en-us/iaas/Content/API/References/apierrors.htm#apierrors_%s__%s_%s", this.statusCode, this.statusCode, StringUtils.isNotBlank(this.serviceCode) ? this.serviceCode.toLowerCase() : "");
            return String.format("Error returned by %s operation in %s service.(%s, %s, %s) %s%s\nTimestamp: %s\nClient version: %s\nRequest Endpoint: %s\nTroubleshooting Tips: See %s for more information about resolving this error\nAlso see %s for details on this operation's requirements.\nTo get more info on the failing request, you can enable debug level logs as mentioned in `Using SLF4J for Logging section` in https://docs.oracle.com/en-us/iaas/Content/API/SDKDocs/javasdkconfig.htm.\nIf you are unable to resolve this %s issue, please contact Oracle support and provide them this full error message.", this.serviceDetails.getOperationName(), targetService, this.statusCode, this.serviceCode, this.timeout, super.getMessage(), requestId, timestamp, clientVersion, this.serviceDetails.getRequestEndpoint(), errorTroubleshootingLink, this.serviceDetails.getApiReferenceLink(), targetService);
        }
        return String.format("(%s, %s, %s) %s%s", this.statusCode, this.serviceCode, this.timeout, super.getMessage(), requestId);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public boolean isClientSide() {
        return this.isClientSide;
    }

    public ServiceDetails getServiceDetails() {
        return this.serviceDetails;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    public String getOriginalMessageTemplate() {
        return this.originalMessageTemplate;
    }

    public Map<String, String> getMessageArguments() {
        return this.messageArguments;
    }
}

