/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.CompositeClientConfigurator;
import com.oracle.bmc.http.DefaultConfigurator;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientFactoryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RestClientFactoryBuilder.class);
    public static final ClientConfigurator DEFAULT_CONFIGURATOR = new DefaultConfigurator();
    private ClientConfigurator defaultConfigurator = DEFAULT_CONFIGURATOR;
    private ClientConfigurator clientConfigurator;
    private List<ClientConfigurator> additionalClientConfigurators = new ArrayList<ClientConfigurator>();

    public static RestClientFactoryBuilder builder() {
        return new RestClientFactoryBuilder();
    }

    public RestClientFactoryBuilder defaultConfigurator(ClientConfigurator defaultConfigurator) {
        this.defaultConfigurator = defaultConfigurator != null ? defaultConfigurator : DEFAULT_CONFIGURATOR;
        return this;
    }

    public RestClientFactoryBuilder clientConfigurator(ClientConfigurator clientConfigurator) {
        this.clientConfigurator = clientConfigurator;
        return this;
    }

    public RestClientFactoryBuilder additionalClientConfigurators(ClientConfigurator ... clientConfigurators) {
        this.additionalClientConfigurators = Collections.unmodifiableList(new ArrayList<ClientConfigurator>(Arrays.asList(clientConfigurators)));
        return this;
    }

    public RestClientFactoryBuilder additionalClientConfigurators(List<ClientConfigurator> clientConfigurators) {
        this.additionalClientConfigurators = Collections.unmodifiableList(new ArrayList<ClientConfigurator>(clientConfigurators));
        return this;
    }

    public RestClientFactory build() {
        ClientConfigurator preferredClientConfigurator = this.getClientConfigurator();
        ArrayList<ClientConfigurator> configurators = new ArrayList<ClientConfigurator>();
        configurators.add(preferredClientConfigurator);
        configurators.addAll(this.additionalClientConfigurators);
        return new RestClientFactory(new CompositeClientConfigurator(Collections.unmodifiableList(configurators)));
    }

    @InternalSdk
    @VisibleForTesting
    protected ClientConfigurator getClientConfigurator() {
        return this.clientConfigurator != null ? this.clientConfigurator : this.defaultConfigurator;
    }

    @InternalSdk
    @VisibleForTesting
    protected List<ClientConfigurator> getAdditionalClientConfigurators() {
        return this.additionalClientConfigurators;
    }

    protected RestClientFactoryBuilder() {
    }
}

