/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import com.oracle.bmc.http.internal.HttpDateUtils;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.ReflectionUtils;
import com.oracle.bmc.util.internal.StringUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;

public enum HttpUtils {


    public static String urlPathSegmentEscape(String pathSegment) {
        try {
            String encoded = URLEncoder.encode(pathSegment, "UTF-8");
            StringBuilder sb = new StringBuilder();
            int i = 0;
            block9: while (i < encoded.length()) {
                char ch = encoded.charAt(i);
                if (ch == '+') {
                    sb.append("%20");
                    ++i;
                    continue;
                }
                if (ch == '%' && i + 2 < encoded.length()) {
                    char ch2 = encoded.charAt(i + 1);
                    char ch3 = encoded.charAt(i + 2);
                    if (ch2 == '2') {
                        switch (ch3) {
                            case '1': {
                                sb.append("!");
                                i += 3;
                                continue block9;
                            }
                            case '7': {
                                sb.append("'");
                                i += 3;
                                continue block9;
                            }
                            case '8': {
                                sb.append("(");
                                i += 3;
                                continue block9;
                            }
                            case '9': {
                                sb.append(")");
                                i += 3;
                                continue block9;
                            }
                            case 'B': {
                                sb.append("+");
                                i += 3;
                                continue block9;
                            }
                        }
                    } else {
                        if (ch2 == '3' && ch3 == 'A') {
                            sb.append(":");
                            i += 3;
                            continue;
                        }
                        if (ch2 == '4' && ch3 == '0') {
                            sb.append("@");
                            i += 3;
                            continue;
                        }
                        if (ch2 == '7' && ch3 == 'E') {
                            sb.append("~");
                            i += 3;
                            continue;
                        }
                    }
                }
                sb.append(ch);
                ++i;
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static String encodePathSegment(@Nonnull String pathSegment) {
        if (pathSegment.isEmpty()) {
            throw new IllegalArgumentException("Cannot provide empty path segment");
        }
        return HttpUtils.urlPathSegmentEscape(pathSegment);
    }

    public static String encodePathSegment(@Nonnull Number pathSegment) {
        return HttpUtils.encodePathSegment(pathSegment.toString());
    }

    public static String encodePathSegment(@Nonnull Boolean pathSegment) {
        return HttpUtils.encodePathSegment(pathSegment.toString());
    }

    public static String encodePathSegment(@Nonnull Character pathSegment) {
        return HttpUtils.encodePathSegment(pathSegment.toString());
    }

    public static String encodePathSegment(@Nonnull UUID pathSegment) {
        return HttpUtils.encodePathSegment(pathSegment.toString());
    }

    public static Object attemptEncodeQueryParam(Object queryParam) {
        if (queryParam instanceof Date) {
            return HttpDateUtils.format((Date)queryParam);
        }
        if (queryParam instanceof String) {
            return HttpUtils.urlPathSegmentEscape((String)queryParam);
        }
        return queryParam;
    }

    public static WrappedWebTarget encodeMapQueryParam(WrappedWebTarget target, String prefix, Map<String, ?> queryParam) {
        if (prefix == null) {
            prefix = "";
        }
        if (queryParam != null) {
            for (Map.Entry<String, ?> e : queryParam.entrySet()) {
                target = HttpUtils.encodeMapQueryParamValue(target, prefix + e.getKey(), e.getValue());
            }
        }
        return target;
    }

    public static <T> WrappedWebTarget encodeCollectionFormatQueryParam(WrappedWebTarget target, String queryParamName, List<T> values, CollectionFormatType collectionFormatType) {
        Validate.notBlank(queryParamName, "a non-blank queryParamName must be provided", new Object[0]);
        if (values != null && !values.isEmpty()) {
            ArrayList<String> valuesToUse = new ArrayList<String>();
            for (T v : values) {
                if (v == null) continue;
                if (v instanceof Enum) {
                    Object rawValue = ReflectionUtils.invokeGetter(v, "getValue");
                    if (rawValue != null) {
                        valuesToUse.add((String)rawValue);
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Could not get the correct value for enum %s", v.getClass().getCanonicalName()));
                }
                valuesToUse.add((String)v);
            }
            if (valuesToUse.isEmpty()) {
                return target;
            }
            if (collectionFormatType == CollectionFormatType.CommaSeparated) {
                target = target.queryParam(queryParamName, HttpUtils.attemptEncodeQueryParam(StringUtils.join(valuesToUse, ",")));
            } else if (collectionFormatType == CollectionFormatType.PipeSeparated) {
                target = target.queryParam(queryParamName, HttpUtils.attemptEncodeQueryParam(StringUtils.join(valuesToUse, "|")));
            } else if (collectionFormatType == CollectionFormatType.SpaceSeparated) {
                target = target.queryParam(queryParamName, HttpUtils.attemptEncodeQueryParam(StringUtils.join(valuesToUse, " ")));
            } else if (collectionFormatType == CollectionFormatType.TabSeparated) {
                target = target.queryParam(queryParamName, HttpUtils.attemptEncodeQueryParam(StringUtils.join(valuesToUse, "\t")));
            } else if (collectionFormatType == CollectionFormatType.Multi) {
                Object[] encodedValuesToUse = new Object[valuesToUse.size()];
                for (int i = 0; i < valuesToUse.size(); ++i) {
                    encodedValuesToUse[i] = HttpUtils.attemptEncodeQueryParam(valuesToUse.get(i));
                }
                target = target.queryParam(queryParamName, encodedValuesToUse);
            } else {
                throw new IllegalArgumentException(String.format("Unknown collection format type: %s", new Object[]{collectionFormatType}));
            }
        }
        return target;
    }

    private static WrappedWebTarget encodeMapQueryParamValue(WrappedWebTarget target, String prefixedKey, Object value) {
        String name = HttpUtils.attemptEncodeQueryParam(prefixedKey).toString();
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            for (Object v : c) {
                target = target.queryParam(name, HttpUtils.attemptEncodeQueryParam(v));
            }
        } else {
            target = target.queryParam(name, HttpUtils.attemptEncodeQueryParam(value));
        }
        return target;
    }
}

