/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http;

import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.JerseyDefaultConnectorConfigurator;
import com.oracle.bmc.http.internal.CrossTenancyRequestClientFilter;
import com.oracle.bmc.util.internal.Validate;
import java.util.Arrays;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

public class CrossTenancyRequestConfigurator
implements ClientConfigurator {
    private final ClientConfigurator baseConfigurator;
    private final String[] authorizedTenancyIds;

    public CrossTenancyRequestConfigurator(String[] authorizedTenancyIds) {
        this(authorizedTenancyIds, new JerseyDefaultConnectorConfigurator());
    }

    public CrossTenancyRequestConfigurator(String[] authorizedTenancyIds, ClientConfigurator baseConfigurator) {
        this.baseConfigurator = Validate.notNull(baseConfigurator, "baseConfigurator may not be null", new Object[0]);
        if (authorizedTenancyIds == null || authorizedTenancyIds.length == 0) {
            throw new IllegalArgumentException("Must provide at least one authorized tenancyId");
        }
        for (String authorizedTenancyId : authorizedTenancyIds) {
            if (authorizedTenancyId != null && !authorizedTenancyId.isEmpty()) continue;
            throw new IllegalArgumentException("Authorized tenancyId was not valid");
        }
        this.authorizedTenancyIds = Arrays.copyOf(authorizedTenancyIds, authorizedTenancyIds.length);
    }

    @Override
    public void customizeBuilder(ClientBuilder builder) {
        this.baseConfigurator.customizeBuilder(builder);
    }

    @Override
    public void customizeClient(Client client) {
        this.baseConfigurator.customizeClient(client);
        client.register((Object)new CrossTenancyRequestClientFilter(this.authorizedTenancyIds));
    }
}

