/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.DefaultRetryCondition;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.FixedTimeDelayStrategy;
import com.oracle.bmc.waiter.MaxAttemptsTerminationStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public class TokenRefreshRetrier
extends BmcGenericRetrier {
    private static TerminationStrategy TOKEN_REFRESH_TERMINATION_STRATEGY = new MaxAttemptsTerminationStrategy(2);
    private static DelayStrategy TOKEN_REFRESH_DELAY_STRATEGY = new FixedTimeDelayStrategy(0L);

    private static RetryConfiguration createTokenRefreshRetryConfiguration(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        if (authenticationDetailsProvider == null) {
            throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
        }
        RetryConfiguration tokenRefreshRetryConfiguration = RetryConfiguration.builder().terminationStrategy(TOKEN_REFRESH_TERMINATION_STRATEGY).delayStrategy(TOKEN_REFRESH_DELAY_STRATEGY).retryCondition(e -> {
            if ((e.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode() || DefaultRetryCondition.isProcessingException(e)) && authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                ((RefreshableOnNotAuthenticatedProvider)((Object)authenticationDetailsProvider)).refresh();
                return true;
            }
            return false;
        }).build();
        return tokenRefreshRetryConfiguration;
    }

    public TokenRefreshRetrier(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(TokenRefreshRetrier.createTokenRefreshRetryConfiguration(authenticationDetailsProvider));
        if (authenticationDetailsProvider == null) {
            throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
        }
    }
}

