/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util;

import com.oracle.bmc.Realm;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.internal.EndpointBuilder;
import com.oracle.bmc.util.internal.StringUtils;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmSpecificEndpointTemplateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RealmSpecificEndpointTemplateUtils.class);
    private static final String OCI_REALM_SPECIFIC_SERVICE_ENDPOINT_TEMPLATE_ENABLED_ENV_VAR = "OCI_REALM_SPECIFIC_SERVICE_ENDPOINT_TEMPLATE_ENABLED";

    public static boolean getUseOfRealmSpecificEndpointTemplateByDefault() {
        String useOfRealmSpecificEndpointTemplateEnabledEnvVar = System.getenv(OCI_REALM_SPECIFIC_SERVICE_ENDPOINT_TEMPLATE_ENABLED_ENV_VAR);
        return useOfRealmSpecificEndpointTemplateEnabledEnvVar != null && useOfRealmSpecificEndpointTemplateEnabledEnvVar.equalsIgnoreCase("true");
    }

    public static String getRealmSpecificEndpointTemplate(boolean useOfRealmSpecificEndpointTemplateEnabled, String regionId, Service service) {
        if (StringUtils.isBlank(regionId)) {
            throw new NullPointerException("Cannot determine the realm since regionId is null or blank. useRealmSpecificEndpointTemplate() can only be used if regionId is set.");
        }
        try {
            Realm realm = Region.fromRegionId(regionId).getRealm();
            if (useOfRealmSpecificEndpointTemplateEnabled && service.getServiceEndpointTemplateForRealmMap() == null) {
                useOfRealmSpecificEndpointTemplateEnabled = false;
                LOG.debug("Realm-specific endpoint template not defined for realm {}, using non-realm-specific endpoint template instead.", (Object)realm.getRealmId().toLowerCase(Locale.ROOT));
            }
            String endpointTemplateToUse = useOfRealmSpecificEndpointTemplateEnabled ? EndpointBuilder.getRealmSpecificEndpointTemplate(regionId, service, realm) : EndpointBuilder.getServiceEndpointTemplateToUse(regionId, service, realm);
            LOG.debug("Setting endpoint template to: {}", (Object)endpointTemplateToUse);
            return endpointTemplateToUse;
        }
        catch (IllegalArgumentException e) {
            String defaultEndpointTemplate = Region.formatDefaultRegionEndpoint(service, regionId);
            LOG.info("Cannot determine the realm for unknown regionId '{}', falling back to default endpoint format `{}`", (Object)regionId, (Object)defaultEndpointTemplate);
            return defaultEndpointTemplate;
        }
    }
}

