/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.waiter.WaiterConfiguration;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericWaiter {
    private static final Logger LOG = LoggerFactory.getLogger(GenericWaiter.class);
    private final WaiterConfiguration waiterConfiguration;

    @Deprecated
    public <REQUEST, RESPONSE> com.google.common.base.Optional<RESPONSE> execute(Supplier<REQUEST> requestSupplier, Function<REQUEST, RESPONSE> functionCall, com.google.common.base.Predicate<RESPONSE> terminationPredicate) {
        return GuavaUtils.adaptToGuava(this.execute(GuavaUtils.adaptFromGuava(requestSupplier), GuavaUtils.adaptFromGuava(functionCall), GuavaUtils.adaptFromGuava(terminationPredicate)));
    }

    public <REQUEST, RESPONSE> Optional<RESPONSE> execute(java.util.function.Supplier<REQUEST> requestSupplier, java.util.function.Function<REQUEST, RESPONSE> functionCall, Predicate<RESPONSE> terminationPredicate) {
        WaiterConfiguration.WaitContext context = new WaiterConfiguration.WaitContext(System.currentTimeMillis());
        Object r = null;
        while (true) {
            LOG.debug("Invoking function call");
            r = functionCall.apply(requestSupplier.get());
            if (terminationPredicate.test(r)) {
                LOG.debug("Total Latency for this API call is: {}ms", (Object)(context.getCurrentTime() - context.getStartTime()));
                return Optional.of(r);
            }
            context.incrementAttempts();
            context.setCurrentTime(System.currentTimeMillis());
            LOG.debug("Retry attempt: {}", (Object)context.getAttemptsMade());
            if (this.waiterConfiguration.getTerminationStrategy().shouldTerminate(context)) break;
            try {
                long sleepTime = this.waiterConfiguration.getDelayStrategy().nextDelay(context);
                LOG.debug("Sleeping for {}ms, context at: {}", (Object)sleepTime, (Object)context);
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                LOG.info("Waiter interrupted");
                Thread.currentThread().interrupt();
                return Optional.empty();
            }
        }
        LOG.debug("Termination strategy decided to terminate with context at: {}", (Object)context);
        LOG.debug("Total Latency for this API call is: {}ms", (Object)(context.getCurrentTime() - context.getStartTime()));
        return Optional.empty();
    }

    @ConstructorProperties(value={"waiterConfiguration"})
    public GenericWaiter(WaiterConfiguration waiterConfiguration) {
        this.waiterConfiguration = waiterConfiguration;
    }

    public WaiterConfiguration getWaiterConfiguration() {
        return this.waiterConfiguration;
    }
}

