/**
 * Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.Region;

/**
 * A region provider has the API to return the region.
 *
 * <p>An {@link AbstractAuthenticationDetailsProvider} can also implements this interface as a way
 * to bootstrap a client during initialization using the Region returned by this interface.
 */
public interface RegionProvider {
    /**
     * Returns the region.
     *
     * @return Region object.
     */
    Region getRegion();
}
