/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.NoCircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.OciCircuitBreaker;
import com.oracle.bmc.circuitbreaker.internal.resilience4j.OciCircuitBreakerImpl;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.model.BmcException;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

@InternalSdk
public class CircuitBreakerHelper {
    private CircuitBreakerHelper() {
    }

    public static OciCircuitBreaker makeCircuitBreaker(HttpClient httpClient, @Nullable CircuitBreakerConfiguration circuitBreakerConfiguration) {
        Objects.requireNonNull(httpClient, "httpClient");
        if (circuitBreakerConfiguration == null || circuitBreakerConfiguration instanceof NoCircuitBreakerConfiguration) {
            return null;
        }
        Predicate<Throwable> recordExceptionPredicate = e -> {
            if (e instanceof Exception && circuitBreakerConfiguration.isRecordProcessingFailures() && httpClient.isProcessingException((Exception)e)) {
                return true;
            }
            if (!(e instanceof BmcException)) {
                return false;
            }
            int statusCode = ((BmcException)e).getStatusCode();
            if (statusCode == 409 && ((BmcException)e).getServiceCode().equals("IncorrectState")) {
                return true;
            }
            return circuitBreakerConfiguration.getRecordHttpStatuses().contains(statusCode);
        };
        return new OciCircuitBreakerImpl(circuitBreakerConfiguration, recordExceptionPredicate);
    }
}

