/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.retrier;

import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.retrier.RetryCondition;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waiter.GenericWaiter;
import com.oracle.bmc.waiter.WaiterScheduler;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcGenericRetrier {
    private static final Logger LOG = LoggerFactory.getLogger(BmcGenericRetrier.class);
    private final GenericWaiter waiter;
    private final RetryCondition retryCondition;

    public BmcGenericRetrier(@Nonnull RetryConfiguration retryConfiguration) {
        if (retryConfiguration == null) {
            throw new NullPointerException("retryConfiguration is marked non-null but is null");
        }
        this.waiter = new GenericWaiter(retryConfiguration);
        this.retryCondition = retryConfiguration.getRetryCondition();
    }

    public <REQUEST, RESPONSE> RESPONSE execute(@Nonnull REQUEST requestToUse, @Nonnull Function<REQUEST, RESPONSE> functionCall) {
        if (requestToUse == null) {
            throw new NullPointerException("requestToUse is marked non-null but is null");
        }
        if (functionCall == null) {
            throw new NullPointerException("functionCall is marked non-null but is null");
        }
        AtomicReference lastKnownException = new AtomicReference();
        LOG.debug("Retry policy to use: {MaximumNumberAttempts={}, MinSleepBetween=0, MaxSleepBetween={}ms, ExponentialBackoffBase=2}", (Object)8, (Object)RetryConfiguration.DEFAULT_MAX_WAIT_TIME);
        Optional<Object> response = this.waiter.execute(() -> requestToUse, request -> {
            if (lastKnownException.get() != null) {
                LOG.debug("Http Status Code: {}, Error Code: {}, Retrying: {}", new Object[]{((BmcException)lastKnownException.get()).getStatusCode(), ((BmcException)lastKnownException.get()).getServiceCode(), ((BmcException)lastKnownException.get()).getMessage()});
            }
            try {
                return this.doFunctionCall(request, functionCall);
            }
            catch (BmcException e) {
                if (!this.retryCondition.shouldBeRetried(e)) {
                    LOG.debug("Http Status Code: {}, Error Code: {}, Not retrying, not retriable: {}", new Object[]{e.getStatusCode(), e.getServiceCode(), e.getMessage()});
                    throw e;
                }
                lastKnownException.set(e);
                return null;
            }
        }, Objects::nonNull);
        if (response.isPresent()) {
            return (RESPONSE)response.get();
        }
        throw (BmcException)lastKnownException.get();
    }

    public final <REQUEST, RESPONSE> CompletionStage<RESPONSE> executeAsync(WaiterScheduler runner, @Nonnull REQUEST requestToUse, @Nonnull Function<REQUEST, CompletionStage<RESPONSE>> functionCall) {
        AtomicReference lastKnownException = new AtomicReference();
        return this.waiter.executeAsync(runner, () -> {
            if (lastKnownException.get() != null) {
                LOG.debug("Retrying: {}", (Object)((BmcException)lastKnownException.get()).getMessage());
            }
            return this.doFunctionCallAsync(requestToUse, functionCall).handle((r, t) -> {
                if ((t = BmcGenericRetrier.unwrap(t)) instanceof BmcException && this.retryCondition.shouldBeRetried((BmcException)t)) {
                    lastKnownException.set((BmcException)t);
                    return null;
                }
                if (t == null) {
                    return r;
                }
                LOG.debug("Not retrying, not retriable: {}", (Object)t.getMessage());
                throw new CompletionException((Throwable)t);
            });
        }, Objects::nonNull).thenCompose(res -> {
            if (res.isPresent()) {
                return CompletableFuture.completedFuture(res.get());
            }
            throw (BmcException)lastKnownException.get();
        });
    }

    private static Throwable unwrap(Throwable t) {
        if (t instanceof CompletionException && t.getCause() != null) {
            return t.getCause();
        }
        return t;
    }

    protected <REQUEST, RESPONSE> RESPONSE doFunctionCall(@Nonnull REQUEST request, @Nonnull Function<REQUEST, RESPONSE> functionCall) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (functionCall == null) {
            throw new NullPointerException("functionCall is marked non-null but is null");
        }
        return functionCall.apply(request);
    }

    protected <REQUEST, RESPONSE> CompletionStage<RESPONSE> doFunctionCallAsync(@Nullable @Nonnull REQUEST request, @Nonnull Function<REQUEST, CompletionStage<RESPONSE>> functionCall) {
        return this.doFunctionCall(request, functionCall);
    }

    public GenericWaiter getWaiter() {
        return this.waiter;
    }

    public RetryCondition getRetryCondition() {
        return this.retryCondition;
    }
}

