/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.internal;

import com.oracle.bmc.internal.SpiClientConfigurator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultConfiguratorHolder {
    private static final Logger LOG = LoggerFactory.getLogger(SpiClientConfigurator.class);
    private static List<SpiClientConfigurator> DEFAULT;

    DefaultConfiguratorHolder() {
    }

    public static synchronized List<SpiClientConfigurator> getDefault() {
        if (DEFAULT == null) {
            DEFAULT = DefaultConfiguratorHolder.findConfigurator();
        }
        return DEFAULT;
    }

    private static List<SpiClientConfigurator> findConfigurator() {
        Iterator<SpiClientConfigurator> itr = ServiceLoader.load(SpiClientConfigurator.class).iterator();
        ArrayList<SpiClientConfigurator> configurators = new ArrayList<SpiClientConfigurator>();
        ServiceConfigurationError lastException = null;
        while (itr.hasNext()) {
            try {
                configurators.add(itr.next());
            }
            catch (ServiceConfigurationError e) {
                if (lastException != null) {
                    LOG.error("Additional caught exception", (Throwable)lastException);
                }
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return configurators;
    }
}

