/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.model.internal;

import com.oracle.bmc.http.client.Serializer;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConverter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonConverter.class);

    public static <T> T jsonBlobToObject(@Nonnull String jsonBlob, @Nonnull Class<T> clazz) {
        if (jsonBlob == null) {
            throw new NullPointerException("jsonBlob is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Object object = null;
        try {
            object = Serializer.getDefault().readValue(jsonBlob, clazz);
        }
        catch (Exception e) {
            LOG.error("Exception in parsing out json blob {}", (Object)jsonBlob, (Object)e);
        }
        return (T)object;
    }

    public static <T> String objectToJsonBlob(@Nonnull T object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        String jsonBlob = null;
        try {
            jsonBlob = Serializer.getDefault().writeValueAsString(object);
        }
        catch (Exception e) {
            LOG.error("Exception in writing json blob from object {}", object, (Object)e);
        }
        return jsonBlob;
    }
}

