/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computecloudatcustomer;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.computecloudatcustomer.ComputeCloudAtCustomerAsync;
import com.oracle.bmc.computecloudatcustomer.model.CccInfrastructure;
import com.oracle.bmc.computecloudatcustomer.model.CccInfrastructureCollection;
import com.oracle.bmc.computecloudatcustomer.model.CccUpgradeSchedule;
import com.oracle.bmc.computecloudatcustomer.model.CccUpgradeScheduleCollection;
import com.oracle.bmc.computecloudatcustomer.requests.ChangeCccInfrastructureCompartmentRequest;
import com.oracle.bmc.computecloudatcustomer.requests.ChangeCccUpgradeScheduleCompartmentRequest;
import com.oracle.bmc.computecloudatcustomer.requests.CreateCccInfrastructureRequest;
import com.oracle.bmc.computecloudatcustomer.requests.CreateCccUpgradeScheduleRequest;
import com.oracle.bmc.computecloudatcustomer.requests.DeleteCccInfrastructureRequest;
import com.oracle.bmc.computecloudatcustomer.requests.DeleteCccUpgradeScheduleRequest;
import com.oracle.bmc.computecloudatcustomer.requests.GetCccInfrastructureRequest;
import com.oracle.bmc.computecloudatcustomer.requests.GetCccUpgradeScheduleRequest;
import com.oracle.bmc.computecloudatcustomer.requests.ListCccInfrastructuresRequest;
import com.oracle.bmc.computecloudatcustomer.requests.ListCccUpgradeSchedulesRequest;
import com.oracle.bmc.computecloudatcustomer.requests.UpdateCccInfrastructureRequest;
import com.oracle.bmc.computecloudatcustomer.requests.UpdateCccUpgradeScheduleRequest;
import com.oracle.bmc.computecloudatcustomer.responses.ChangeCccInfrastructureCompartmentResponse;
import com.oracle.bmc.computecloudatcustomer.responses.ChangeCccUpgradeScheduleCompartmentResponse;
import com.oracle.bmc.computecloudatcustomer.responses.CreateCccInfrastructureResponse;
import com.oracle.bmc.computecloudatcustomer.responses.CreateCccUpgradeScheduleResponse;
import com.oracle.bmc.computecloudatcustomer.responses.DeleteCccInfrastructureResponse;
import com.oracle.bmc.computecloudatcustomer.responses.DeleteCccUpgradeScheduleResponse;
import com.oracle.bmc.computecloudatcustomer.responses.GetCccInfrastructureResponse;
import com.oracle.bmc.computecloudatcustomer.responses.GetCccUpgradeScheduleResponse;
import com.oracle.bmc.computecloudatcustomer.responses.ListCccInfrastructuresResponse;
import com.oracle.bmc.computecloudatcustomer.responses.ListCccUpgradeSchedulesResponse;
import com.oracle.bmc.computecloudatcustomer.responses.UpdateCccInfrastructureResponse;
import com.oracle.bmc.computecloudatcustomer.responses.UpdateCccUpgradeScheduleResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeCloudAtCustomerAsyncClient
extends BaseAsyncClient
implements ComputeCloudAtCustomerAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTECLOUDATCUSTOMER").serviceEndpointPrefix("").serviceEndpointTemplate("https://ccc.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ComputeCloudAtCustomerAsyncClient.class);

    ComputeCloudAtCustomerAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeCccInfrastructureCompartmentResponse> changeCccInfrastructureCompartment(ChangeCccInfrastructureCompartmentRequest request, AsyncHandler<ChangeCccInfrastructureCompartmentRequest, ChangeCccInfrastructureCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCccInfrastructureId(), (String)"cccInfrastructureId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCccInfrastructureCompartmentDetails(), "changeCccInfrastructureCompartmentDetails is required");
        return this.clientCall(request, ChangeCccInfrastructureCompartmentResponse::builder).logger(LOG, "changeCccInfrastructureCompartment").serviceDetails("ComputeCloudAtCustomer", "ChangeCccInfrastructureCompartment", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccInfrastructure/ChangeCccInfrastructureCompartment").method(Method.POST).requestBuilder(ChangeCccInfrastructureCompartmentRequest::builder).basePath("/20221208").appendPathParam("cccInfrastructures").appendPathParam(request.getCccInfrastructureId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeCccInfrastructureCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeCccUpgradeScheduleCompartmentResponse> changeCccUpgradeScheduleCompartment(ChangeCccUpgradeScheduleCompartmentRequest request, AsyncHandler<ChangeCccUpgradeScheduleCompartmentRequest, ChangeCccUpgradeScheduleCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCccUpgradeScheduleId(), (String)"cccUpgradeScheduleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeCccUpgradeScheduleCompartmentDetails(), "changeCccUpgradeScheduleCompartmentDetails is required");
        return this.clientCall(request, ChangeCccUpgradeScheduleCompartmentResponse::builder).logger(LOG, "changeCccUpgradeScheduleCompartment").serviceDetails("ComputeCloudAtCustomer", "ChangeCccUpgradeScheduleCompartment", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccUpgradeSchedule/ChangeCccUpgradeScheduleCompartment").method(Method.POST).requestBuilder(ChangeCccUpgradeScheduleCompartmentRequest::builder).basePath("/20221208").appendPathParam("cccUpgradeSchedules").appendPathParam(request.getCccUpgradeScheduleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeCccUpgradeScheduleCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateCccInfrastructureResponse> createCccInfrastructure(CreateCccInfrastructureRequest request, AsyncHandler<CreateCccInfrastructureRequest, CreateCccInfrastructureResponse> handler) {
        Objects.requireNonNull(request.getCreateCccInfrastructureDetails(), "createCccInfrastructureDetails is required");
        return this.clientCall(request, CreateCccInfrastructureResponse::builder).logger(LOG, "createCccInfrastructure").serviceDetails("ComputeCloudAtCustomer", "CreateCccInfrastructure", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccInfrastructure/CreateCccInfrastructure").method(Method.POST).requestBuilder(CreateCccInfrastructureRequest::builder).basePath("/20221208").appendPathParam("cccInfrastructures").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(CccInfrastructure.class, CreateCccInfrastructureResponse.Builder::cccInfrastructure).handleResponseHeaderString("etag", CreateCccInfrastructureResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCccInfrastructureResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateCccUpgradeScheduleResponse> createCccUpgradeSchedule(CreateCccUpgradeScheduleRequest request, AsyncHandler<CreateCccUpgradeScheduleRequest, CreateCccUpgradeScheduleResponse> handler) {
        Objects.requireNonNull(request.getCreateCccUpgradeScheduleDetails(), "createCccUpgradeScheduleDetails is required");
        return this.clientCall(request, CreateCccUpgradeScheduleResponse::builder).logger(LOG, "createCccUpgradeSchedule").serviceDetails("ComputeCloudAtCustomer", "CreateCccUpgradeSchedule", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccUpgradeSchedule/CreateCccUpgradeSchedule").method(Method.POST).requestBuilder(CreateCccUpgradeScheduleRequest::builder).basePath("/20221208").appendPathParam("cccUpgradeSchedules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(CccUpgradeSchedule.class, CreateCccUpgradeScheduleResponse.Builder::cccUpgradeSchedule).handleResponseHeaderString("etag", CreateCccUpgradeScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateCccUpgradeScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteCccInfrastructureResponse> deleteCccInfrastructure(DeleteCccInfrastructureRequest request, AsyncHandler<DeleteCccInfrastructureRequest, DeleteCccInfrastructureResponse> handler) {
        Validate.notBlank((String)request.getCccInfrastructureId(), (String)"cccInfrastructureId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteCccInfrastructureResponse::builder).logger(LOG, "deleteCccInfrastructure").serviceDetails("ComputeCloudAtCustomer", "DeleteCccInfrastructure", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccInfrastructure/DeleteCccInfrastructure").method(Method.DELETE).requestBuilder(DeleteCccInfrastructureRequest::builder).basePath("/20221208").appendPathParam("cccInfrastructures").appendPathParam(request.getCccInfrastructureId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteCccInfrastructureResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteCccUpgradeScheduleResponse> deleteCccUpgradeSchedule(DeleteCccUpgradeScheduleRequest request, AsyncHandler<DeleteCccUpgradeScheduleRequest, DeleteCccUpgradeScheduleResponse> handler) {
        Validate.notBlank((String)request.getCccUpgradeScheduleId(), (String)"cccUpgradeScheduleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteCccUpgradeScheduleResponse::builder).logger(LOG, "deleteCccUpgradeSchedule").serviceDetails("ComputeCloudAtCustomer", "DeleteCccUpgradeSchedule", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccUpgradeSchedule/DeleteCccUpgradeSchedule").method(Method.DELETE).requestBuilder(DeleteCccUpgradeScheduleRequest::builder).basePath("/20221208").appendPathParam("cccUpgradeSchedules").appendPathParam(request.getCccUpgradeScheduleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteCccUpgradeScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCccInfrastructureResponse> getCccInfrastructure(GetCccInfrastructureRequest request, AsyncHandler<GetCccInfrastructureRequest, GetCccInfrastructureResponse> handler) {
        Validate.notBlank((String)request.getCccInfrastructureId(), (String)"cccInfrastructureId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCccInfrastructureResponse::builder).logger(LOG, "getCccInfrastructure").serviceDetails("ComputeCloudAtCustomer", "GetCccInfrastructure", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccInfrastructure/GetCccInfrastructure").method(Method.GET).requestBuilder(GetCccInfrastructureRequest::builder).basePath("/20221208").appendPathParam("cccInfrastructures").appendPathParam(request.getCccInfrastructureId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CccInfrastructure.class, GetCccInfrastructureResponse.Builder::cccInfrastructure).handleResponseHeaderString("etag", GetCccInfrastructureResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCccInfrastructureResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetCccUpgradeScheduleResponse> getCccUpgradeSchedule(GetCccUpgradeScheduleRequest request, AsyncHandler<GetCccUpgradeScheduleRequest, GetCccUpgradeScheduleResponse> handler) {
        Validate.notBlank((String)request.getCccUpgradeScheduleId(), (String)"cccUpgradeScheduleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetCccUpgradeScheduleResponse::builder).logger(LOG, "getCccUpgradeSchedule").serviceDetails("ComputeCloudAtCustomer", "GetCccUpgradeSchedule", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccUpgradeSchedule/GetCccUpgradeSchedule").method(Method.GET).requestBuilder(GetCccUpgradeScheduleRequest::builder).basePath("/20221208").appendPathParam("cccUpgradeSchedules").appendPathParam(request.getCccUpgradeScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CccUpgradeSchedule.class, GetCccUpgradeScheduleResponse.Builder::cccUpgradeSchedule).handleResponseHeaderString("etag", GetCccUpgradeScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCccUpgradeScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListCccInfrastructuresResponse> listCccInfrastructures(ListCccInfrastructuresRequest request, AsyncHandler<ListCccInfrastructuresRequest, ListCccInfrastructuresResponse> handler) {
        return this.clientCall(request, ListCccInfrastructuresResponse::builder).logger(LOG, "listCccInfrastructures").serviceDetails("ComputeCloudAtCustomer", "ListCccInfrastructures", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccInfrastructureCollection/ListCccInfrastructures").method(Method.GET).requestBuilder(ListCccInfrastructuresRequest::builder).basePath("/20221208").appendPathParam("cccInfrastructures").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("cccInfrastructureId", (Object)request.getCccInfrastructureId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CccInfrastructureCollection.class, ListCccInfrastructuresResponse.Builder::cccInfrastructureCollection).handleResponseHeaderString("opc-request-id", ListCccInfrastructuresResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCccInfrastructuresResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListCccInfrastructuresResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<ListCccUpgradeSchedulesResponse> listCccUpgradeSchedules(ListCccUpgradeSchedulesRequest request, AsyncHandler<ListCccUpgradeSchedulesRequest, ListCccUpgradeSchedulesResponse> handler) {
        return this.clientCall(request, ListCccUpgradeSchedulesResponse::builder).logger(LOG, "listCccUpgradeSchedules").serviceDetails("ComputeCloudAtCustomer", "ListCccUpgradeSchedules", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccUpgradeScheduleCollection/ListCccUpgradeSchedules").method(Method.GET).requestBuilder(ListCccUpgradeSchedulesRequest::builder).basePath("/20221208").appendPathParam("cccUpgradeSchedules").appendQueryParam("cccUpgradeScheduleId", (Object)request.getCccUpgradeScheduleId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendEnumQueryParam("accessLevel", (BmcEnum)request.getAccessLevel()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(CccUpgradeScheduleCollection.class, ListCccUpgradeSchedulesResponse.Builder::cccUpgradeScheduleCollection).handleResponseHeaderString("opc-request-id", ListCccUpgradeSchedulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCccUpgradeSchedulesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListCccUpgradeSchedulesResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<UpdateCccInfrastructureResponse> updateCccInfrastructure(UpdateCccInfrastructureRequest request, AsyncHandler<UpdateCccInfrastructureRequest, UpdateCccInfrastructureResponse> handler) {
        Validate.notBlank((String)request.getCccInfrastructureId(), (String)"cccInfrastructureId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCccInfrastructureDetails(), "updateCccInfrastructureDetails is required");
        return this.clientCall(request, UpdateCccInfrastructureResponse::builder).logger(LOG, "updateCccInfrastructure").serviceDetails("ComputeCloudAtCustomer", "UpdateCccInfrastructure", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccInfrastructure/UpdateCccInfrastructure").method(Method.PUT).requestBuilder(UpdateCccInfrastructureRequest::builder).basePath("/20221208").appendPathParam("cccInfrastructures").appendPathParam(request.getCccInfrastructureId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(CccInfrastructure.class, UpdateCccInfrastructureResponse.Builder::cccInfrastructure).handleResponseHeaderString("etag", UpdateCccInfrastructureResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCccInfrastructureResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateCccUpgradeScheduleResponse> updateCccUpgradeSchedule(UpdateCccUpgradeScheduleRequest request, AsyncHandler<UpdateCccUpgradeScheduleRequest, UpdateCccUpgradeScheduleResponse> handler) {
        Validate.notBlank((String)request.getCccUpgradeScheduleId(), (String)"cccUpgradeScheduleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateCccUpgradeScheduleDetails(), "updateCccUpgradeScheduleDetails is required");
        return this.clientCall(request, UpdateCccUpgradeScheduleResponse::builder).logger(LOG, "updateCccUpgradeSchedule").serviceDetails("ComputeCloudAtCustomer", "UpdateCccUpgradeSchedule", "https://docs.oracle.com/iaas/api/#/en/compute-cloud-at-customer/20221208/CccUpgradeSchedule/UpdateCccUpgradeSchedule").method(Method.PUT).requestBuilder(UpdateCccUpgradeScheduleRequest::builder).basePath("/20221208").appendPathParam("cccUpgradeSchedules").appendPathParam(request.getCccUpgradeScheduleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(CccUpgradeSchedule.class, UpdateCccUpgradeScheduleResponse.Builder::cccUpgradeSchedule).handleResponseHeaderString("etag", UpdateCccUpgradeScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateCccUpgradeScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ComputeCloudAtCustomerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ComputeCloudAtCustomerAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeCloudAtCustomerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ComputeCloudAtCustomerAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeCloudAtCustomerAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ComputeCloudAtCustomerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeCloudAtCustomerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ComputeCloudAtCustomerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeCloudAtCustomerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ComputeCloudAtCustomerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeCloudAtCustomerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ComputeCloudAtCustomerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeCloudAtCustomerAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ComputeCloudAtCustomerAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeCloudAtCustomerAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "computecloudatcustomer";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"computecloudatcustomer");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ComputeCloudAtCustomerAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ComputeCloudAtCustomerAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

