/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computecloudatcustomer;

import com.oracle.bmc.computecloudatcustomer.ComputeCloudAtCustomer;
import com.oracle.bmc.computecloudatcustomer.model.CccInfrastructureSummary;
import com.oracle.bmc.computecloudatcustomer.model.CccUpgradeScheduleSummary;
import com.oracle.bmc.computecloudatcustomer.requests.ListCccInfrastructuresRequest;
import com.oracle.bmc.computecloudatcustomer.requests.ListCccUpgradeSchedulesRequest;
import com.oracle.bmc.computecloudatcustomer.responses.ListCccInfrastructuresResponse;
import com.oracle.bmc.computecloudatcustomer.responses.ListCccUpgradeSchedulesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ComputeCloudAtCustomerPaginators {
    private final ComputeCloudAtCustomer client;

    public ComputeCloudAtCustomerPaginators(ComputeCloudAtCustomer client) {
        this.client = client;
    }

    public Iterable<ListCccInfrastructuresResponse> listCccInfrastructuresResponseIterator(final ListCccInfrastructuresRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCccInfrastructuresRequest.Builder>(){

            @Override
            public ListCccInfrastructuresRequest.Builder get() {
                return ListCccInfrastructuresRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCccInfrastructuresResponse, String>(){

            @Override
            public String apply(ListCccInfrastructuresResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCccInfrastructuresRequest.Builder>, ListCccInfrastructuresRequest>(){

            @Override
            public ListCccInfrastructuresRequest apply(RequestBuilderAndToken<ListCccInfrastructuresRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCccInfrastructuresRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCccInfrastructuresRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCccInfrastructuresRequest, ListCccInfrastructuresResponse>(){

            @Override
            public ListCccInfrastructuresResponse apply(ListCccInfrastructuresRequest request) {
                return ComputeCloudAtCustomerPaginators.this.client.listCccInfrastructures(request);
            }
        });
    }

    public Iterable<CccInfrastructureSummary> listCccInfrastructuresRecordIterator(final ListCccInfrastructuresRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCccInfrastructuresRequest.Builder>(){

            @Override
            public ListCccInfrastructuresRequest.Builder get() {
                return ListCccInfrastructuresRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCccInfrastructuresResponse, String>(){

            @Override
            public String apply(ListCccInfrastructuresResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCccInfrastructuresRequest.Builder>, ListCccInfrastructuresRequest>(){

            @Override
            public ListCccInfrastructuresRequest apply(RequestBuilderAndToken<ListCccInfrastructuresRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCccInfrastructuresRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCccInfrastructuresRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCccInfrastructuresRequest, ListCccInfrastructuresResponse>(){

            @Override
            public ListCccInfrastructuresResponse apply(ListCccInfrastructuresRequest request) {
                return ComputeCloudAtCustomerPaginators.this.client.listCccInfrastructures(request);
            }
        }, (Function)new Function<ListCccInfrastructuresResponse, List<CccInfrastructureSummary>>(){

            @Override
            public List<CccInfrastructureSummary> apply(ListCccInfrastructuresResponse response) {
                return response.getCccInfrastructureCollection().getItems();
            }
        });
    }

    public Iterable<ListCccUpgradeSchedulesResponse> listCccUpgradeSchedulesResponseIterator(final ListCccUpgradeSchedulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCccUpgradeSchedulesRequest.Builder>(){

            @Override
            public ListCccUpgradeSchedulesRequest.Builder get() {
                return ListCccUpgradeSchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCccUpgradeSchedulesResponse, String>(){

            @Override
            public String apply(ListCccUpgradeSchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCccUpgradeSchedulesRequest.Builder>, ListCccUpgradeSchedulesRequest>(){

            @Override
            public ListCccUpgradeSchedulesRequest apply(RequestBuilderAndToken<ListCccUpgradeSchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCccUpgradeSchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCccUpgradeSchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCccUpgradeSchedulesRequest, ListCccUpgradeSchedulesResponse>(){

            @Override
            public ListCccUpgradeSchedulesResponse apply(ListCccUpgradeSchedulesRequest request) {
                return ComputeCloudAtCustomerPaginators.this.client.listCccUpgradeSchedules(request);
            }
        });
    }

    public Iterable<CccUpgradeScheduleSummary> listCccUpgradeSchedulesRecordIterator(final ListCccUpgradeSchedulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCccUpgradeSchedulesRequest.Builder>(){

            @Override
            public ListCccUpgradeSchedulesRequest.Builder get() {
                return ListCccUpgradeSchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCccUpgradeSchedulesResponse, String>(){

            @Override
            public String apply(ListCccUpgradeSchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCccUpgradeSchedulesRequest.Builder>, ListCccUpgradeSchedulesRequest>(){

            @Override
            public ListCccUpgradeSchedulesRequest apply(RequestBuilderAndToken<ListCccUpgradeSchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCccUpgradeSchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCccUpgradeSchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCccUpgradeSchedulesRequest, ListCccUpgradeSchedulesResponse>(){

            @Override
            public ListCccUpgradeSchedulesResponse apply(ListCccUpgradeSchedulesRequest request) {
                return ComputeCloudAtCustomerPaginators.this.client.listCccUpgradeSchedules(request);
            }
        }, (Function)new Function<ListCccUpgradeSchedulesResponse, List<CccUpgradeScheduleSummary>>(){

            @Override
            public List<CccUpgradeScheduleSummary> apply(ListCccUpgradeSchedulesResponse response) {
                return response.getCccUpgradeScheduleCollection().getItems();
            }
        });
    }
}

