/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computecloudatcustomer;

import com.oracle.bmc.computecloudatcustomer.ComputeCloudAtCustomer;
import com.oracle.bmc.computecloudatcustomer.model.CccInfrastructure;
import com.oracle.bmc.computecloudatcustomer.model.CccUpgradeSchedule;
import com.oracle.bmc.computecloudatcustomer.requests.GetCccInfrastructureRequest;
import com.oracle.bmc.computecloudatcustomer.requests.GetCccUpgradeScheduleRequest;
import com.oracle.bmc.computecloudatcustomer.responses.GetCccInfrastructureResponse;
import com.oracle.bmc.computecloudatcustomer.responses.GetCccUpgradeScheduleResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ComputeCloudAtCustomerWaiters {
    private final ExecutorService executorService;
    private final ComputeCloudAtCustomer client;

    public ComputeCloudAtCustomerWaiters(ExecutorService executorService, ComputeCloudAtCustomer client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetCccInfrastructureRequest, GetCccInfrastructureResponse> forCccInfrastructure(GetCccInfrastructureRequest request, CccInfrastructure.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCccInfrastructure(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCccInfrastructureRequest, GetCccInfrastructureResponse> forCccInfrastructure(GetCccInfrastructureRequest request, CccInfrastructure.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCccInfrastructure(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCccInfrastructureRequest, GetCccInfrastructureResponse> forCccInfrastructure(GetCccInfrastructureRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CccInfrastructure.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCccInfrastructure(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCccInfrastructureRequest, GetCccInfrastructureResponse> forCccInfrastructure(BmcGenericWaiter waiter, GetCccInfrastructureRequest request, CccInfrastructure.LifecycleState ... targetStates) {
        final HashSet<CccInfrastructure.LifecycleState> targetStatesSet = new HashSet<CccInfrastructure.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCccInfrastructureRequest, GetCccInfrastructureResponse>(){

            @Override
            public GetCccInfrastructureResponse apply(GetCccInfrastructureRequest request) {
                return ComputeCloudAtCustomerWaiters.this.client.getCccInfrastructure(request);
            }
        }, (Predicate)new Predicate<GetCccInfrastructureResponse>(){

            @Override
            public boolean test(GetCccInfrastructureResponse response) {
                return targetStatesSet.contains((Object)response.getCccInfrastructure().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CccInfrastructure.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetCccUpgradeScheduleRequest, GetCccUpgradeScheduleResponse> forCccUpgradeSchedule(GetCccUpgradeScheduleRequest request, CccUpgradeSchedule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forCccUpgradeSchedule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetCccUpgradeScheduleRequest, GetCccUpgradeScheduleResponse> forCccUpgradeSchedule(GetCccUpgradeScheduleRequest request, CccUpgradeSchedule.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forCccUpgradeSchedule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetCccUpgradeScheduleRequest, GetCccUpgradeScheduleResponse> forCccUpgradeSchedule(GetCccUpgradeScheduleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, CccUpgradeSchedule.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forCccUpgradeSchedule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetCccUpgradeScheduleRequest, GetCccUpgradeScheduleResponse> forCccUpgradeSchedule(BmcGenericWaiter waiter, GetCccUpgradeScheduleRequest request, CccUpgradeSchedule.LifecycleState ... targetStates) {
        final HashSet<CccUpgradeSchedule.LifecycleState> targetStatesSet = new HashSet<CccUpgradeSchedule.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetCccUpgradeScheduleRequest, GetCccUpgradeScheduleResponse>(){

            @Override
            public GetCccUpgradeScheduleResponse apply(GetCccUpgradeScheduleRequest request) {
                return ComputeCloudAtCustomerWaiters.this.client.getCccUpgradeSchedule(request);
            }
        }, (Predicate)new Predicate<GetCccUpgradeScheduleResponse>(){

            @Override
            public boolean test(GetCccUpgradeScheduleResponse response) {
                return targetStatesSet.contains((Object)response.getCccUpgradeSchedule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)CccUpgradeSchedule.LifecycleState.Deleted)), (Object)request);
    }
}

