/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computecloudatcustomer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CccInfrastructureInventory
extends ExplicitlySetBmcModel {
    @JsonProperty(value="serialNumber")
    private final String serialNumber;
    @JsonProperty(value="managementNodeCount")
    private final Integer managementNodeCount;
    @JsonProperty(value="computeNodeCount")
    private final Integer computeNodeCount;
    @JsonProperty(value="capacityStorageTrayCount")
    private final Integer capacityStorageTrayCount;
    @JsonProperty(value="performanceStorageTrayCount")
    private final Integer performanceStorageTrayCount;

    @Deprecated
    @ConstructorProperties(value={"serialNumber", "managementNodeCount", "computeNodeCount", "capacityStorageTrayCount", "performanceStorageTrayCount"})
    public CccInfrastructureInventory(String serialNumber, Integer managementNodeCount, Integer computeNodeCount, Integer capacityStorageTrayCount, Integer performanceStorageTrayCount) {
        this.serialNumber = serialNumber;
        this.managementNodeCount = managementNodeCount;
        this.computeNodeCount = computeNodeCount;
        this.capacityStorageTrayCount = capacityStorageTrayCount;
        this.performanceStorageTrayCount = performanceStorageTrayCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public Integer getManagementNodeCount() {
        return this.managementNodeCount;
    }

    public Integer getComputeNodeCount() {
        return this.computeNodeCount;
    }

    public Integer getCapacityStorageTrayCount() {
        return this.capacityStorageTrayCount;
    }

    public Integer getPerformanceStorageTrayCount() {
        return this.performanceStorageTrayCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CccInfrastructureInventory(");
        sb.append("super=").append(super.toString());
        sb.append("serialNumber=").append(String.valueOf(this.serialNumber));
        sb.append(", managementNodeCount=").append(String.valueOf(this.managementNodeCount));
        sb.append(", computeNodeCount=").append(String.valueOf(this.computeNodeCount));
        sb.append(", capacityStorageTrayCount=").append(String.valueOf(this.capacityStorageTrayCount));
        sb.append(", performanceStorageTrayCount=").append(String.valueOf(this.performanceStorageTrayCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CccInfrastructureInventory)) {
            return false;
        }
        CccInfrastructureInventory other = (CccInfrastructureInventory)((Object)o);
        return Objects.equals(this.serialNumber, other.serialNumber) && Objects.equals(this.managementNodeCount, other.managementNodeCount) && Objects.equals(this.computeNodeCount, other.computeNodeCount) && Objects.equals(this.capacityStorageTrayCount, other.capacityStorageTrayCount) && Objects.equals(this.performanceStorageTrayCount, other.performanceStorageTrayCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.serialNumber == null ? 43 : this.serialNumber.hashCode());
        result = result * 59 + (this.managementNodeCount == null ? 43 : this.managementNodeCount.hashCode());
        result = result * 59 + (this.computeNodeCount == null ? 43 : this.computeNodeCount.hashCode());
        result = result * 59 + (this.capacityStorageTrayCount == null ? 43 : this.capacityStorageTrayCount.hashCode());
        result = result * 59 + (this.performanceStorageTrayCount == null ? 43 : this.performanceStorageTrayCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="serialNumber")
        private String serialNumber;
        @JsonProperty(value="managementNodeCount")
        private Integer managementNodeCount;
        @JsonProperty(value="computeNodeCount")
        private Integer computeNodeCount;
        @JsonProperty(value="capacityStorageTrayCount")
        private Integer capacityStorageTrayCount;
        @JsonProperty(value="performanceStorageTrayCount")
        private Integer performanceStorageTrayCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.__explicitlySet__.add("serialNumber");
            return this;
        }

        public Builder managementNodeCount(Integer managementNodeCount) {
            this.managementNodeCount = managementNodeCount;
            this.__explicitlySet__.add("managementNodeCount");
            return this;
        }

        public Builder computeNodeCount(Integer computeNodeCount) {
            this.computeNodeCount = computeNodeCount;
            this.__explicitlySet__.add("computeNodeCount");
            return this;
        }

        public Builder capacityStorageTrayCount(Integer capacityStorageTrayCount) {
            this.capacityStorageTrayCount = capacityStorageTrayCount;
            this.__explicitlySet__.add("capacityStorageTrayCount");
            return this;
        }

        public Builder performanceStorageTrayCount(Integer performanceStorageTrayCount) {
            this.performanceStorageTrayCount = performanceStorageTrayCount;
            this.__explicitlySet__.add("performanceStorageTrayCount");
            return this;
        }

        public CccInfrastructureInventory build() {
            CccInfrastructureInventory model = new CccInfrastructureInventory(this.serialNumber, this.managementNodeCount, this.computeNodeCount, this.capacityStorageTrayCount, this.performanceStorageTrayCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CccInfrastructureInventory model) {
            if (model.wasPropertyExplicitlySet("serialNumber")) {
                this.serialNumber(model.getSerialNumber());
            }
            if (model.wasPropertyExplicitlySet("managementNodeCount")) {
                this.managementNodeCount(model.getManagementNodeCount());
            }
            if (model.wasPropertyExplicitlySet("computeNodeCount")) {
                this.computeNodeCount(model.getComputeNodeCount());
            }
            if (model.wasPropertyExplicitlySet("capacityStorageTrayCount")) {
                this.capacityStorageTrayCount(model.getCapacityStorageTrayCount());
            }
            if (model.wasPropertyExplicitlySet("performanceStorageTrayCount")) {
                this.performanceStorageTrayCount(model.getPerformanceStorageTrayCount());
            }
            return this;
        }
    }
}

