/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computecloudatcustomer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.computecloudatcustomer.model.PeerInformation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CccInfrastructureRoutingDynamicDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="peerInformation")
    private final List<PeerInformation> peerInformation;
    @JsonProperty(value="oracleAsn")
    private final Integer oracleAsn;
    @JsonProperty(value="bgpTopology")
    private final BgpTopology bgpTopology;

    @Deprecated
    @ConstructorProperties(value={"peerInformation", "oracleAsn", "bgpTopology"})
    public CccInfrastructureRoutingDynamicDetails(List<PeerInformation> peerInformation, Integer oracleAsn, BgpTopology bgpTopology) {
        this.peerInformation = peerInformation;
        this.oracleAsn = oracleAsn;
        this.bgpTopology = bgpTopology;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<PeerInformation> getPeerInformation() {
        return this.peerInformation;
    }

    public Integer getOracleAsn() {
        return this.oracleAsn;
    }

    public BgpTopology getBgpTopology() {
        return this.bgpTopology;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CccInfrastructureRoutingDynamicDetails(");
        sb.append("super=").append(super.toString());
        sb.append("peerInformation=").append(String.valueOf(this.peerInformation));
        sb.append(", oracleAsn=").append(String.valueOf(this.oracleAsn));
        sb.append(", bgpTopology=").append(String.valueOf((Object)this.bgpTopology));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CccInfrastructureRoutingDynamicDetails)) {
            return false;
        }
        CccInfrastructureRoutingDynamicDetails other = (CccInfrastructureRoutingDynamicDetails)((Object)o);
        return Objects.equals(this.peerInformation, other.peerInformation) && Objects.equals(this.oracleAsn, other.oracleAsn) && Objects.equals((Object)this.bgpTopology, (Object)other.bgpTopology) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.peerInformation == null ? 43 : this.peerInformation.hashCode());
        result = result * 59 + (this.oracleAsn == null ? 43 : this.oracleAsn.hashCode());
        result = result * 59 + (this.bgpTopology == null ? 43 : this.bgpTopology.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BgpTopology implements BmcEnum
    {
        Triangle("TRIANGLE"),
        Square("SQUARE"),
        Mesh("MESH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BgpTopology> map;

        private BgpTopology(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BgpTopology create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BgpTopology', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BgpTopology.class);
            map = new HashMap<String, BgpTopology>();
            for (BgpTopology v : BgpTopology.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="peerInformation")
        private List<PeerInformation> peerInformation;
        @JsonProperty(value="oracleAsn")
        private Integer oracleAsn;
        @JsonProperty(value="bgpTopology")
        private BgpTopology bgpTopology;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder peerInformation(List<PeerInformation> peerInformation) {
            this.peerInformation = peerInformation;
            this.__explicitlySet__.add("peerInformation");
            return this;
        }

        public Builder oracleAsn(Integer oracleAsn) {
            this.oracleAsn = oracleAsn;
            this.__explicitlySet__.add("oracleAsn");
            return this;
        }

        public Builder bgpTopology(BgpTopology bgpTopology) {
            this.bgpTopology = bgpTopology;
            this.__explicitlySet__.add("bgpTopology");
            return this;
        }

        public CccInfrastructureRoutingDynamicDetails build() {
            CccInfrastructureRoutingDynamicDetails model = new CccInfrastructureRoutingDynamicDetails(this.peerInformation, this.oracleAsn, this.bgpTopology);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CccInfrastructureRoutingDynamicDetails model) {
            if (model.wasPropertyExplicitlySet("peerInformation")) {
                this.peerInformation(model.getPeerInformation());
            }
            if (model.wasPropertyExplicitlySet("oracleAsn")) {
                this.oracleAsn(model.getOracleAsn());
            }
            if (model.wasPropertyExplicitlySet("bgpTopology")) {
                this.bgpTopology(model.getBgpTopology());
            }
            return this;
        }
    }
}

