/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computecloudatcustomer.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CccUpgradeInformation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="currentVersion")
    private final String currentVersion;
    @JsonProperty(value="timeOfScheduledUpgrade")
    private final Date timeOfScheduledUpgrade;
    @JsonProperty(value="scheduledUpgradeDuration")
    private final String scheduledUpgradeDuration;
    @JsonProperty(value="isActive")
    private final Boolean isActive;

    @Deprecated
    @ConstructorProperties(value={"currentVersion", "timeOfScheduledUpgrade", "scheduledUpgradeDuration", "isActive"})
    public CccUpgradeInformation(String currentVersion, Date timeOfScheduledUpgrade, String scheduledUpgradeDuration, Boolean isActive) {
        this.currentVersion = currentVersion;
        this.timeOfScheduledUpgrade = timeOfScheduledUpgrade;
        this.scheduledUpgradeDuration = scheduledUpgradeDuration;
        this.isActive = isActive;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public Date getTimeOfScheduledUpgrade() {
        return this.timeOfScheduledUpgrade;
    }

    public String getScheduledUpgradeDuration() {
        return this.scheduledUpgradeDuration;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CccUpgradeInformation(");
        sb.append("super=").append(super.toString());
        sb.append("currentVersion=").append(String.valueOf(this.currentVersion));
        sb.append(", timeOfScheduledUpgrade=").append(String.valueOf(this.timeOfScheduledUpgrade));
        sb.append(", scheduledUpgradeDuration=").append(String.valueOf(this.scheduledUpgradeDuration));
        sb.append(", isActive=").append(String.valueOf(this.isActive));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CccUpgradeInformation)) {
            return false;
        }
        CccUpgradeInformation other = (CccUpgradeInformation)((Object)o);
        return Objects.equals(this.currentVersion, other.currentVersion) && Objects.equals(this.timeOfScheduledUpgrade, other.timeOfScheduledUpgrade) && Objects.equals(this.scheduledUpgradeDuration, other.scheduledUpgradeDuration) && Objects.equals(this.isActive, other.isActive) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.currentVersion == null ? 43 : this.currentVersion.hashCode());
        result = result * 59 + (this.timeOfScheduledUpgrade == null ? 43 : this.timeOfScheduledUpgrade.hashCode());
        result = result * 59 + (this.scheduledUpgradeDuration == null ? 43 : this.scheduledUpgradeDuration.hashCode());
        result = result * 59 + (this.isActive == null ? 43 : this.isActive.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="currentVersion")
        private String currentVersion;
        @JsonProperty(value="timeOfScheduledUpgrade")
        private Date timeOfScheduledUpgrade;
        @JsonProperty(value="scheduledUpgradeDuration")
        private String scheduledUpgradeDuration;
        @JsonProperty(value="isActive")
        private Boolean isActive;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            this.__explicitlySet__.add("currentVersion");
            return this;
        }

        public Builder timeOfScheduledUpgrade(Date timeOfScheduledUpgrade) {
            this.timeOfScheduledUpgrade = timeOfScheduledUpgrade;
            this.__explicitlySet__.add("timeOfScheduledUpgrade");
            return this;
        }

        public Builder scheduledUpgradeDuration(String scheduledUpgradeDuration) {
            this.scheduledUpgradeDuration = scheduledUpgradeDuration;
            this.__explicitlySet__.add("scheduledUpgradeDuration");
            return this;
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            this.__explicitlySet__.add("isActive");
            return this;
        }

        public CccUpgradeInformation build() {
            CccUpgradeInformation model = new CccUpgradeInformation(this.currentVersion, this.timeOfScheduledUpgrade, this.scheduledUpgradeDuration, this.isActive);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CccUpgradeInformation model) {
            if (model.wasPropertyExplicitlySet("currentVersion")) {
                this.currentVersion(model.getCurrentVersion());
            }
            if (model.wasPropertyExplicitlySet("timeOfScheduledUpgrade")) {
                this.timeOfScheduledUpgrade(model.getTimeOfScheduledUpgrade());
            }
            if (model.wasPropertyExplicitlySet("scheduledUpgradeDuration")) {
                this.scheduledUpgradeDuration(model.getScheduledUpgradeDuration());
            }
            if (model.wasPropertyExplicitlySet("isActive")) {
                this.isActive(model.getIsActive());
            }
            return this;
        }
    }
}

