/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computecloudatcustomer.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCccUpgradeScheduleRequest
extends BmcRequest<Void> {
    private String cccUpgradeScheduleId;
    private String opcRequestId;

    public String getCccUpgradeScheduleId() {
        return this.cccUpgradeScheduleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().cccUpgradeScheduleId(this.cccUpgradeScheduleId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",cccUpgradeScheduleId=").append(String.valueOf(this.cccUpgradeScheduleId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCccUpgradeScheduleRequest)) {
            return false;
        }
        GetCccUpgradeScheduleRequest other = (GetCccUpgradeScheduleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.cccUpgradeScheduleId, other.cccUpgradeScheduleId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cccUpgradeScheduleId == null ? 43 : this.cccUpgradeScheduleId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCccUpgradeScheduleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String cccUpgradeScheduleId = null;
        private String opcRequestId = null;

        public Builder cccUpgradeScheduleId(String cccUpgradeScheduleId) {
            this.cccUpgradeScheduleId = cccUpgradeScheduleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCccUpgradeScheduleRequest o) {
            this.cccUpgradeScheduleId(o.getCccUpgradeScheduleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCccUpgradeScheduleRequest build() {
            GetCccUpgradeScheduleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCccUpgradeScheduleRequest buildWithoutInvocationCallback() {
            GetCccUpgradeScheduleRequest request = new GetCccUpgradeScheduleRequest();
            request.cccUpgradeScheduleId = this.cccUpgradeScheduleId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

