/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.computeinstanceagent.Plugin;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentPluginSummary;
import com.oracle.bmc.computeinstanceagent.requests.ListInstanceAgentPluginsRequest;
import com.oracle.bmc.computeinstanceagent.responses.ListInstanceAgentPluginsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class PluginPaginators {
    private final Plugin client;

    public Iterable<ListInstanceAgentPluginsResponse> listInstanceAgentPluginsResponseIterator(final ListInstanceAgentPluginsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListInstanceAgentPluginsRequest.Builder>(){

            public ListInstanceAgentPluginsRequest.Builder get() {
                return ListInstanceAgentPluginsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInstanceAgentPluginsResponse, String>(){

            public String apply(ListInstanceAgentPluginsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInstanceAgentPluginsRequest.Builder>, ListInstanceAgentPluginsRequest>(){

            public ListInstanceAgentPluginsRequest apply(RequestBuilderAndToken<ListInstanceAgentPluginsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListInstanceAgentPluginsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInstanceAgentPluginsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListInstanceAgentPluginsRequest, ListInstanceAgentPluginsResponse>(){

            public ListInstanceAgentPluginsResponse apply(ListInstanceAgentPluginsRequest request) {
                return PluginPaginators.this.client.listInstanceAgentPlugins(request);
            }
        });
    }

    public Iterable<InstanceAgentPluginSummary> listInstanceAgentPluginsRecordIterator(final ListInstanceAgentPluginsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListInstanceAgentPluginsRequest.Builder>(){

            public ListInstanceAgentPluginsRequest.Builder get() {
                return ListInstanceAgentPluginsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInstanceAgentPluginsResponse, String>(){

            public String apply(ListInstanceAgentPluginsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInstanceAgentPluginsRequest.Builder>, ListInstanceAgentPluginsRequest>(){

            public ListInstanceAgentPluginsRequest apply(RequestBuilderAndToken<ListInstanceAgentPluginsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListInstanceAgentPluginsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInstanceAgentPluginsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListInstanceAgentPluginsRequest, ListInstanceAgentPluginsResponse>(){

            public ListInstanceAgentPluginsResponse apply(ListInstanceAgentPluginsRequest request) {
                return PluginPaginators.this.client.listInstanceAgentPlugins(request);
            }
        }, (Function)new Function<ListInstanceAgentPluginsResponse, List<InstanceAgentPluginSummary>>(){

            public List<InstanceAgentPluginSummary> apply(ListInstanceAgentPluginsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public PluginPaginators(Plugin client) {
        this.client = client;
    }
}

