/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommand;
import com.oracle.bmc.computeinstanceagent.requests.CreateInstanceAgentCommandRequest;
import com.oracle.bmc.computeinstanceagent.responses.CreateInstanceAgentCommandResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateInstanceAgentCommandConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateInstanceAgentCommandConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateInstanceAgentCommandRequest interceptRequest(CreateInstanceAgentCommandRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateInstanceAgentCommandRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateInstanceAgentCommandDetails(), (String)"createInstanceAgentCommandDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20180530").path("instanceAgentCommands");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateInstanceAgentCommandResponse> fromResponse() {
        Function<Response, CreateInstanceAgentCommandResponse> transformer = new Function<Response, CreateInstanceAgentCommandResponse>(){

            public CreateInstanceAgentCommandResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.computeinstanceagent.responses.CreateInstanceAgentCommandResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(InstanceAgentCommand.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateInstanceAgentCommandResponse.Builder builder = CreateInstanceAgentCommandResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.instanceAgentCommand((InstanceAgentCommand)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                CreateInstanceAgentCommandResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

