/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class CancelInstanceAgentCommandRequest
extends BmcRequest<Void> {
    private String instanceAgentCommandId;
    private String opcRequestId;
    private String ifMatch;

    @ConstructorProperties(value={"instanceAgentCommandId", "opcRequestId", "ifMatch"})
    CancelInstanceAgentCommandRequest(String instanceAgentCommandId, String opcRequestId, String ifMatch) {
        this.instanceAgentCommandId = instanceAgentCommandId;
        this.opcRequestId = opcRequestId;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceAgentCommandId() {
        return this.instanceAgentCommandId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelInstanceAgentCommandRequest, Void> {
        private String instanceAgentCommandId;
        private String opcRequestId;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelInstanceAgentCommandRequest o) {
            this.instanceAgentCommandId(o.getInstanceAgentCommandId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelInstanceAgentCommandRequest build() {
            CancelInstanceAgentCommandRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceAgentCommandId(String instanceAgentCommandId) {
            this.instanceAgentCommandId = instanceAgentCommandId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public CancelInstanceAgentCommandRequest buildWithoutInvocationCallback() {
            return new CancelInstanceAgentCommandRequest(this.instanceAgentCommandId, this.opcRequestId, this.ifMatch);
        }

        public String toString() {
            return "CancelInstanceAgentCommandRequest.Builder(instanceAgentCommandId=" + this.instanceAgentCommandId + ", opcRequestId=" + this.opcRequestId + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

