/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetInstanceAgentCommandExecutionRequest
extends BmcRequest<Void> {
    private String instanceAgentCommandId;
    private String instanceId;
    private String opcRequestId;

    @ConstructorProperties(value={"instanceAgentCommandId", "instanceId", "opcRequestId"})
    GetInstanceAgentCommandExecutionRequest(String instanceAgentCommandId, String instanceId, String opcRequestId) {
        this.instanceAgentCommandId = instanceAgentCommandId;
        this.instanceId = instanceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceAgentCommandId() {
        return this.instanceAgentCommandId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInstanceAgentCommandExecutionRequest, Void> {
        private String instanceAgentCommandId;
        private String instanceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstanceAgentCommandExecutionRequest o) {
            this.instanceAgentCommandId(o.getInstanceAgentCommandId());
            this.instanceId(o.getInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstanceAgentCommandExecutionRequest build() {
            GetInstanceAgentCommandExecutionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceAgentCommandId(String instanceAgentCommandId) {
            this.instanceAgentCommandId = instanceAgentCommandId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetInstanceAgentCommandExecutionRequest buildWithoutInvocationCallback() {
            return new GetInstanceAgentCommandExecutionRequest(this.instanceAgentCommandId, this.instanceId, this.opcRequestId);
        }

        public String toString() {
            return "GetInstanceAgentCommandExecutionRequest.Builder(instanceAgentCommandId=" + this.instanceAgentCommandId + ", instanceId=" + this.instanceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

