/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetInstanceAgentPluginRequest
extends BmcRequest<Void> {
    private String instanceagentId;
    private String compartmentId;
    private String pluginName;
    private String opcRequestId;

    @ConstructorProperties(value={"instanceagentId", "compartmentId", "pluginName", "opcRequestId"})
    GetInstanceAgentPluginRequest(String instanceagentId, String compartmentId, String pluginName, String opcRequestId) {
        this.instanceagentId = instanceagentId;
        this.compartmentId = compartmentId;
        this.pluginName = pluginName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getInstanceagentId() {
        return this.instanceagentId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetInstanceAgentPluginRequest, Void> {
        private String instanceagentId;
        private String compartmentId;
        private String pluginName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetInstanceAgentPluginRequest o) {
            this.instanceagentId(o.getInstanceagentId());
            this.compartmentId(o.getCompartmentId());
            this.pluginName(o.getPluginName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetInstanceAgentPluginRequest build() {
            GetInstanceAgentPluginRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder instanceagentId(String instanceagentId) {
            this.instanceagentId = instanceagentId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetInstanceAgentPluginRequest buildWithoutInvocationCallback() {
            return new GetInstanceAgentPluginRequest(this.instanceagentId, this.compartmentId, this.pluginName, this.opcRequestId);
        }

        public String toString() {
            return "GetInstanceAgentPluginRequest.Builder(instanceagentId=" + this.instanceagentId + ", compartmentId=" + this.compartmentId + ", pluginName=" + this.pluginName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

