/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListInstanceAgentPluginsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String instanceagentId;
    private String opcRequestId;
    private Status status;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String name;

    @ConstructorProperties(value={"compartmentId", "instanceagentId", "opcRequestId", "status", "page", "limit", "sortBy", "sortOrder", "name"})
    ListInstanceAgentPluginsRequest(String compartmentId, String instanceagentId, String opcRequestId, Status status, String page, Integer limit, SortBy sortBy, SortOrder sortOrder, String name) {
        this.compartmentId = compartmentId;
        this.instanceagentId = instanceagentId;
        this.opcRequestId = opcRequestId;
        this.status = status;
        this.page = page;
        this.limit = limit;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.name = name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getInstanceagentId() {
        return this.instanceagentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder
    implements BmcRequest.Builder<ListInstanceAgentPluginsRequest, Void> {
        private String compartmentId;
        private String instanceagentId;
        private String opcRequestId;
        private Status status;
        private String page;
        private Integer limit;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private String name;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListInstanceAgentPluginsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.instanceagentId(o.getInstanceagentId());
            this.opcRequestId(o.getOpcRequestId());
            this.status(o.getStatus());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.name(o.getName());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListInstanceAgentPluginsRequest build() {
            ListInstanceAgentPluginsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder instanceagentId(String instanceagentId) {
            this.instanceagentId = instanceagentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public ListInstanceAgentPluginsRequest buildWithoutInvocationCallback() {
            return new ListInstanceAgentPluginsRequest(this.compartmentId, this.instanceagentId, this.opcRequestId, this.status, this.page, this.limit, this.sortBy, this.sortOrder, this.name);
        }

        public String toString() {
            return "ListInstanceAgentPluginsRequest.Builder(compartmentId=" + this.compartmentId + ", instanceagentId=" + this.instanceagentId + ", opcRequestId=" + this.opcRequestId + ", status=" + (Object)((Object)this.status) + ", page=" + this.page + ", limit=" + this.limit + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", name=" + this.name + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status {
        Running("RUNNING"),
        Stopped("STOPPED"),
        NotSupported("NOT_SUPPORTED"),
        Invalid("INVALID");

        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Status: " + key);
        }

        static {
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

