/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandExecutionOutputContent;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceAgentCommandExecutionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="instanceAgentCommandId")
    private final String instanceAgentCommandId;
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="deliveryState")
    private final DeliveryState deliveryState;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="sequenceNumber")
    private final Long sequenceNumber;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="content")
    private final InstanceAgentCommandExecutionOutputContent content;

    @Deprecated
    @ConstructorProperties(value={"instanceAgentCommandId", "instanceId", "deliveryState", "lifecycleState", "timeCreated", "timeUpdated", "sequenceNumber", "displayName", "content"})
    public InstanceAgentCommandExecutionSummary(String instanceAgentCommandId, String instanceId, DeliveryState deliveryState, LifecycleState lifecycleState, Date timeCreated, Date timeUpdated, Long sequenceNumber, String displayName, InstanceAgentCommandExecutionOutputContent content) {
        this.instanceAgentCommandId = instanceAgentCommandId;
        this.instanceId = instanceId;
        this.deliveryState = deliveryState;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.sequenceNumber = sequenceNumber;
        this.displayName = displayName;
        this.content = content;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInstanceAgentCommandId() {
        return this.instanceAgentCommandId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public DeliveryState getDeliveryState() {
        return this.deliveryState;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public InstanceAgentCommandExecutionOutputContent getContent() {
        return this.content;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceAgentCommandExecutionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("instanceAgentCommandId=").append(String.valueOf(this.instanceAgentCommandId));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", deliveryState=").append(String.valueOf((Object)this.deliveryState));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", sequenceNumber=").append(String.valueOf(this.sequenceNumber));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", content=").append(String.valueOf((Object)this.content));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceAgentCommandExecutionSummary)) {
            return false;
        }
        InstanceAgentCommandExecutionSummary other = (InstanceAgentCommandExecutionSummary)((Object)o);
        return Objects.equals(this.instanceAgentCommandId, other.instanceAgentCommandId) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals((Object)this.deliveryState, (Object)other.deliveryState) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.sequenceNumber, other.sequenceNumber) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.content, (Object)other.content) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.instanceAgentCommandId == null ? 43 : this.instanceAgentCommandId.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.deliveryState == null ? 43 : this.deliveryState.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.sequenceNumber == null ? 43 : this.sequenceNumber.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        TimedOut("TIMED_OUT"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DeliveryState implements BmcEnum
    {
        Visible("VISIBLE"),
        Pending("PENDING"),
        Acked("ACKED"),
        AckedCanceled("ACKED_CANCELED"),
        Expired("EXPIRED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DeliveryState> map;

        private DeliveryState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DeliveryState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DeliveryState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DeliveryState.class);
            map = new HashMap<String, DeliveryState>();
            for (DeliveryState v : DeliveryState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="instanceAgentCommandId")
        private String instanceAgentCommandId;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="deliveryState")
        private DeliveryState deliveryState;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="sequenceNumber")
        private Long sequenceNumber;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="content")
        private InstanceAgentCommandExecutionOutputContent content;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder instanceAgentCommandId(String instanceAgentCommandId) {
            this.instanceAgentCommandId = instanceAgentCommandId;
            this.__explicitlySet__.add("instanceAgentCommandId");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder deliveryState(DeliveryState deliveryState) {
            this.deliveryState = deliveryState;
            this.__explicitlySet__.add("deliveryState");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder sequenceNumber(Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            this.__explicitlySet__.add("sequenceNumber");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder content(InstanceAgentCommandExecutionOutputContent content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public InstanceAgentCommandExecutionSummary build() {
            InstanceAgentCommandExecutionSummary model = new InstanceAgentCommandExecutionSummary(this.instanceAgentCommandId, this.instanceId, this.deliveryState, this.lifecycleState, this.timeCreated, this.timeUpdated, this.sequenceNumber, this.displayName, this.content);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceAgentCommandExecutionSummary model) {
            if (model.wasPropertyExplicitlySet("instanceAgentCommandId")) {
                this.instanceAgentCommandId(model.getInstanceAgentCommandId());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("deliveryState")) {
                this.deliveryState(model.getDeliveryState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("sequenceNumber")) {
                this.sequenceNumber(model.getSequenceNumber());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            return this;
        }
    }
}

