/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent;

import com.oracle.bmc.computeinstanceagent.ComputeInstanceAgent;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandExecution;
import com.oracle.bmc.computeinstanceagent.requests.GetInstanceAgentCommandExecutionRequest;
import com.oracle.bmc.computeinstanceagent.responses.GetInstanceAgentCommandExecutionResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ComputeInstanceAgentWaiters {
    private final ExecutorService executorService;
    private final ComputeInstanceAgent client;

    public ComputeInstanceAgentWaiters(ExecutorService executorService, ComputeInstanceAgent client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetInstanceAgentCommandExecutionRequest, GetInstanceAgentCommandExecutionResponse> forInstanceAgentCommandExecution(GetInstanceAgentCommandExecutionRequest request, InstanceAgentCommandExecution.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forInstanceAgentCommandExecution(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetInstanceAgentCommandExecutionRequest, GetInstanceAgentCommandExecutionResponse> forInstanceAgentCommandExecution(GetInstanceAgentCommandExecutionRequest request, InstanceAgentCommandExecution.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forInstanceAgentCommandExecution(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetInstanceAgentCommandExecutionRequest, GetInstanceAgentCommandExecutionResponse> forInstanceAgentCommandExecution(GetInstanceAgentCommandExecutionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InstanceAgentCommandExecution.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forInstanceAgentCommandExecution(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetInstanceAgentCommandExecutionRequest, GetInstanceAgentCommandExecutionResponse> forInstanceAgentCommandExecution(BmcGenericWaiter waiter, GetInstanceAgentCommandExecutionRequest request, InstanceAgentCommandExecution.LifecycleState ... targetStates) {
        final HashSet<InstanceAgentCommandExecution.LifecycleState> targetStatesSet = new HashSet<InstanceAgentCommandExecution.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetInstanceAgentCommandExecutionRequest, GetInstanceAgentCommandExecutionResponse>(){

            @Override
            public GetInstanceAgentCommandExecutionResponse apply(GetInstanceAgentCommandExecutionRequest request) {
                return ComputeInstanceAgentWaiters.this.client.getInstanceAgentCommandExecution(request);
            }
        }, (Predicate)new Predicate<GetInstanceAgentCommandExecutionResponse>(){

            @Override
            public boolean test(GetInstanceAgentCommandExecutionResponse response) {
                return targetStatesSet.contains((Object)response.getInstanceAgentCommandExecution().getLifecycleState());
            }
        }, false), (Object)request);
    }
}

