/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandContent;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandTarget;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateInstanceAgentCommandDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="executionTimeOutInSeconds")
    private final Integer executionTimeOutInSeconds;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="target")
    private final InstanceAgentCommandTarget target;
    @JsonProperty(value="content")
    private final InstanceAgentCommandContent content;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "executionTimeOutInSeconds", "displayName", "target", "content"})
    public CreateInstanceAgentCommandDetails(String compartmentId, Integer executionTimeOutInSeconds, String displayName, InstanceAgentCommandTarget target, InstanceAgentCommandContent content) {
        this.compartmentId = compartmentId;
        this.executionTimeOutInSeconds = executionTimeOutInSeconds;
        this.displayName = displayName;
        this.target = target;
        this.content = content;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getExecutionTimeOutInSeconds() {
        return this.executionTimeOutInSeconds;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public InstanceAgentCommandTarget getTarget() {
        return this.target;
    }

    public InstanceAgentCommandContent getContent() {
        return this.content;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateInstanceAgentCommandDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", executionTimeOutInSeconds=").append(String.valueOf(this.executionTimeOutInSeconds));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", target=").append(String.valueOf((Object)this.target));
        sb.append(", content=").append(String.valueOf((Object)this.content));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateInstanceAgentCommandDetails)) {
            return false;
        }
        CreateInstanceAgentCommandDetails other = (CreateInstanceAgentCommandDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.executionTimeOutInSeconds, other.executionTimeOutInSeconds) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.target, (Object)other.target) && Objects.equals((Object)this.content, (Object)other.content) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.executionTimeOutInSeconds == null ? 43 : this.executionTimeOutInSeconds.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="executionTimeOutInSeconds")
        private Integer executionTimeOutInSeconds;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="target")
        private InstanceAgentCommandTarget target;
        @JsonProperty(value="content")
        private InstanceAgentCommandContent content;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder executionTimeOutInSeconds(Integer executionTimeOutInSeconds) {
            this.executionTimeOutInSeconds = executionTimeOutInSeconds;
            this.__explicitlySet__.add("executionTimeOutInSeconds");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder target(InstanceAgentCommandTarget target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public Builder content(InstanceAgentCommandContent content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public CreateInstanceAgentCommandDetails build() {
            CreateInstanceAgentCommandDetails model = new CreateInstanceAgentCommandDetails(this.compartmentId, this.executionTimeOutInSeconds, this.displayName, this.target, this.content);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateInstanceAgentCommandDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("executionTimeOutInSeconds")) {
                this.executionTimeOutInSeconds(model.getExecutionTimeOutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            return this;
        }
    }
}

