/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandExecutionSummary;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListInstanceAgentCommandExecutionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String instanceId;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private InstanceAgentCommandExecutionSummary.LifecycleState lifecycleState;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public InstanceAgentCommandExecutionSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).instanceId(this.instanceId).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",instanceId=").append(String.valueOf(this.instanceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListInstanceAgentCommandExecutionsRequest)) {
            return false;
        }
        ListInstanceAgentCommandExecutionsRequest other = (ListInstanceAgentCommandExecutionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListInstanceAgentCommandExecutionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String instanceId = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private InstanceAgentCommandExecutionSummary.LifecycleState lifecycleState = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(InstanceAgentCommandExecutionSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListInstanceAgentCommandExecutionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.instanceId(o.getInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListInstanceAgentCommandExecutionsRequest build() {
            ListInstanceAgentCommandExecutionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListInstanceAgentCommandExecutionsRequest buildWithoutInvocationCallback() {
            ListInstanceAgentCommandExecutionsRequest request = new ListInstanceAgentCommandExecutionsRequest();
            request.compartmentId = this.compartmentId;
            request.instanceId = this.instanceId;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.lifecycleState = this.lifecycleState;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

