/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandContent;
import com.oracle.bmc.computeinstanceagent.model.InstanceAgentCommandTarget;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstanceAgentCommand
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="isCanceled")
    private final Boolean isCanceled;
    @JsonProperty(value="executionTimeOutInSeconds")
    private final Integer executionTimeOutInSeconds;
    @JsonProperty(value="target")
    private final InstanceAgentCommandTarget target;
    @JsonProperty(value="content")
    private final InstanceAgentCommandContent content;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "timeCreated", "timeUpdated", "isCanceled", "executionTimeOutInSeconds", "target", "content"})
    public InstanceAgentCommand(String id, String compartmentId, String displayName, Date timeCreated, Date timeUpdated, Boolean isCanceled, Integer executionTimeOutInSeconds, InstanceAgentCommandTarget target, InstanceAgentCommandContent content) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.isCanceled = isCanceled;
        this.executionTimeOutInSeconds = executionTimeOutInSeconds;
        this.target = target;
        this.content = content;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Boolean getIsCanceled() {
        return this.isCanceled;
    }

    public Integer getExecutionTimeOutInSeconds() {
        return this.executionTimeOutInSeconds;
    }

    public InstanceAgentCommandTarget getTarget() {
        return this.target;
    }

    public InstanceAgentCommandContent getContent() {
        return this.content;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstanceAgentCommand(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", isCanceled=").append(String.valueOf(this.isCanceled));
        sb.append(", executionTimeOutInSeconds=").append(String.valueOf(this.executionTimeOutInSeconds));
        sb.append(", target=").append(String.valueOf((Object)this.target));
        sb.append(", content=").append(String.valueOf((Object)this.content));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceAgentCommand)) {
            return false;
        }
        InstanceAgentCommand other = (InstanceAgentCommand)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.isCanceled, other.isCanceled) && Objects.equals(this.executionTimeOutInSeconds, other.executionTimeOutInSeconds) && Objects.equals((Object)this.target, (Object)other.target) && Objects.equals((Object)this.content, (Object)other.content) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.isCanceled == null ? 43 : this.isCanceled.hashCode());
        result = result * 59 + (this.executionTimeOutInSeconds == null ? 43 : this.executionTimeOutInSeconds.hashCode());
        result = result * 59 + (this.target == null ? 43 : this.target.hashCode());
        result = result * 59 + (this.content == null ? 43 : this.content.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="isCanceled")
        private Boolean isCanceled;
        @JsonProperty(value="executionTimeOutInSeconds")
        private Integer executionTimeOutInSeconds;
        @JsonProperty(value="target")
        private InstanceAgentCommandTarget target;
        @JsonProperty(value="content")
        private InstanceAgentCommandContent content;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder isCanceled(Boolean isCanceled) {
            this.isCanceled = isCanceled;
            this.__explicitlySet__.add("isCanceled");
            return this;
        }

        public Builder executionTimeOutInSeconds(Integer executionTimeOutInSeconds) {
            this.executionTimeOutInSeconds = executionTimeOutInSeconds;
            this.__explicitlySet__.add("executionTimeOutInSeconds");
            return this;
        }

        public Builder target(InstanceAgentCommandTarget target) {
            this.target = target;
            this.__explicitlySet__.add("target");
            return this;
        }

        public Builder content(InstanceAgentCommandContent content) {
            this.content = content;
            this.__explicitlySet__.add("content");
            return this;
        }

        public InstanceAgentCommand build() {
            InstanceAgentCommand model = new InstanceAgentCommand(this.id, this.compartmentId, this.displayName, this.timeCreated, this.timeUpdated, this.isCanceled, this.executionTimeOutInSeconds, this.target, this.content);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstanceAgentCommand model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("isCanceled")) {
                this.isCanceled(model.getIsCanceled());
            }
            if (model.wasPropertyExplicitlySet("executionTimeOutInSeconds")) {
                this.executionTimeOutInSeconds(model.getExecutionTimeOutInSeconds());
            }
            if (model.wasPropertyExplicitlySet("target")) {
                this.target(model.getTarget());
            }
            if (model.wasPropertyExplicitlySet("content")) {
                this.content(model.getContent());
            }
            return this;
        }
    }
}

