/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.computeinstanceagent.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Plugin
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="lastUpdateTime")
    private final Date lastUpdateTime;
    @JsonProperty(value="message")
    private final String message;

    @Deprecated
    @ConstructorProperties(value={"name", "version", "status", "lastUpdateTime", "message"})
    public Plugin(String name, String version, String status, Date lastUpdateTime, String message) {
        this.name = name;
        this.version = version;
        this.status = status;
        this.lastUpdateTime = lastUpdateTime;
        this.message = message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Plugin(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", lastUpdateTime=").append(String.valueOf(this.lastUpdateTime));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Plugin)) {
            return false;
        }
        Plugin other = (Plugin)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status) && Objects.equals(this.lastUpdateTime, other.lastUpdateTime) && Objects.equals(this.message, other.message) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.lastUpdateTime == null ? 43 : this.lastUpdateTime.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="lastUpdateTime")
        private Date lastUpdateTime;
        @JsonProperty(value="message")
        private String message;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder lastUpdateTime(Date lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            this.__explicitlySet__.add("lastUpdateTime");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Plugin build() {
            Plugin model = new Plugin(this.name, this.version, this.status, this.lastUpdateTime, this.message);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Plugin model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("lastUpdateTime")) {
                this.lastUpdateTime(model.getLastUpdateTime());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            return this;
        }
    }
}

